#!/bin/sh
# Restart Tcl/tk \
exec wish "$0" "$@"
#
set VER {testType 02}


# ccrate ϐ́AVXeˑlłBCXg[ɒĂB
# eVXëbԂ̃NbNJEgł
	switch $tcl_platform(platform) {
unix		{set ccrate {1000000}}
macintosh	{set ccrate {1000000}}
windows		{set ccrate {1000}}
default 	{set ccrate {1000000}}
	}
#	Windows	{1000}
#	Linux(Plamo)	{1000000}
#	Mac OS9	{1000000}
#### ʂ̐ݒ
set BackColor	{black}
set ForeColor	{green}
#### Ԃ̐ݒ
### v̐ݒ
set MODE	{clock}
set ClockOption	{12}
set STATUS	{stop}
set RATE	{24FPS}
set frate	{24.}
# RT 24FPS 30NDF 30DF 25FPS
# 
set Log {}

proc Push_Log {str} {
global Log
append Log "${str}\n"
#puts ${str}
}
# end proc

Push_Log "Program Started\t[clock format [clock seconds] -format "%c"]"
Push_Log "\tFrameRate\t${frate}\t(${RATE})\n\tStart Mode\t\[${MODE}\]\n"

######## bv̍őێɋL()
set MaxLap	{12}
##########################################################

proc Clear_LAP {} {
global LAP MaxLap
	for {set point 0} {${point} < ${MaxLap}} {incr point} {
		set LAP(${point}) {}
	}
Push_Log "\tLap memory clear"
}
Clear_LAP

set Start 0
set Stop 0

set display {}
# jOCWP[^ݒ
	set base "|:::::::::::::::::::::::|"
for {set n 0} {$n < 24} {incr n} {
set Ri(${n}) "[string range ${base} 0 ${n}]\|[string range ${base} [expr ${n} + 1] end]"
}
set running $Ri(0)
# mode is \rt \24fps \30DF \30NDF
proc Test {} {
global Start Stop ccrate

set Start	[expr [clock clicks] - int(${ccrate} * 59)]
set Stop	[clock clicks]
}

# clock clicks ̒l烂[hʂɕ\l𐶐
proc cc2dp {cc} {
global display MODE STATUS RATE frate ccrate Start
global running Ri
if {${MODE} == "watch"} then {

#	set frames [expr int(${cc} / (${ccrate} / ${frate}))]
	set frames [cc2FR [expr ${cc} - ${Start}]]

	set TC [FR2TC ${frames}]
#	regsub ^0 [string range ${TC} 0 1] {}	h
#	regsub ^0 [string range ${TC} 3 4] {}	m
#	regsub ^0 [string range ${TC} 6 7] {}	s
	regsub ^0 [string range ${TC} 9 10] {}	f
	
#	set running $Ri([expr int(24 * (${frames} % int(${frate})) / ${frate})])
	set display ${TC}

} else	{
global ClockOption
switch ${ClockOption} {
{12}	{
# 12  
set display [clock format [clock seconds] -format "%I:%M:%S\ %p"]}
default	{
# 24 
set display [clock format [clock seconds] -format "\  %H:%M:%S\  "]}
}
}
#update
return
}
# end proc
# TClt[lZo
proc TC2FR {TC} {
global MODE RATE ccrate	
	regsub ^0 [lindex ${TC} 0] {}	h
	regsub ^0 [lindex ${TC} 1] {}	m
	regsub ^0 [lindex ${TC} 2] {}	s
	regsub ^0 [lindex ${TC} 3] {}	f
#puts -nonewline "${h}: ${m}: ${s}: ${f} >>>"

switch ${RATE} {
{RT}	{
set FR [expr ${h} * 360000 + ${m} * 6000 + ${s} * 100 + ${f}]
}
{24FPS}	{
set FR [expr ${h} * 86400 + ${m} * 1440 + ${s} * 24 + ${f}]
}
{30NDF}	{
set FR [expr ${h} * 108000 + ${m} * 1800 + ${s} * 30 + ${f}]
}
{30DF}	{
set FR [expr ${h} * 107892 + (${m} / 10) * 17982  ]

	if ![expr (${m} % 10)] then {
set FR [expr ${FR} + ${s} * 30 + ${f}] 
	} elseif {${s}} then {
set FR [expr ${FR} + (${m} % 10) * 1800 - ((${m} % 10) - 1) * 2 + ${s} * 28 + (${s} - 1) * 2 + ${f}]
	} else {
if {${f}<=1} then {set f [expr ${f} + 2]}
set FR [expr ${FR} + (${m} % 10) * 1800 - ((${m} % 10) - 1) * 2 + ${f} - 2]
	}
}
default	{
	set FR \
[expr ${h} * ${RATE} * 3600 + ${m} * ${RATE} * 60 + ${s} * ${RATE} + ${f}]
}
}

return ${FR} }
# end proc
# FRlTClZo
proc FR2TC {FR} {
global MODE RATE frate ccrate

#puts -nonewline "${FR} >>>"
switch ${RATE} {
{RT}	{
	set h	[expr (${FR} / 360000) % 100]
	set m	[expr (${FR} / 6000) % 60]
	set s	[expr (${FR} / 100) % 60]
	set f	[expr ${FR} % 100]
set TC [format "%0.2d:%0.2d:%0.2d\.%0.2d" ${h} ${m} ${s} ${f}]
}
{24FPS}	{
	set h	[expr (${FR} / 86400) % 100]
	set m	[expr (${FR} / 1440) % 60]
	set s	[expr (${FR} / 24) % 60]
	set f	[expr ${FR} % 24]
set TC [format "%0.2d:%0.2d:%0.2d\+%0.2d" ${h} ${m} ${s} ${f}]
}
{30NDF}	{
	set h	[expr (${FR} / 108000) % 100]
	set m	[expr (${FR} / 1800) % 60]
	set s	[expr (${FR} / 30) % 60]
	set f	[expr ${FR} % 30]
set TC [format "%0.2d:%0.2d:%0.2d:%0.2d" ${h} ${m} ${s} ${f}]
}
{30DF}	{
set h	[expr (${FR} / 107892) % 100]

	if {[expr ${FR} % 17982] < 1800} then {
set m [expr ((${FR} / 17982) % 6) * 10  + ((${FR} % 17982) / 1800)]
	} else {
set m [expr ((${FR} / 17982) % 6) * 10  + (((${FR} % 17982 ) - 2) / 1798)]
	}

set s [expr (((${m} % 10) * 2 + (${FR} / 17982) * 18 + ${FR}) / 30) % 60]

	if ![expr ${m} % 10] then {
set f [expr ((${m} % 10) * 2 + (${FR} / 17982 ) * 18 + ${FR}) % 30] 
	} elseif !${s} then {
set f [expr (((${FR} / 17982 ) * 18 + ${FR}) % 30) + 2]
	} else {
set f [expr ((${m} % 10) * 2 + (${FR} / 17982 ) * 18 + ${FR}) % 30]
	}
set TC [format "%0.2d:%0.2d:%0.2d\;%0.2d" ${h} ${m} ${s} ${f}]
}
default	{
	set h	[expr int(${FR} / (${frate} * 3600)) % 100]
	set m	[expr int(${FR} / (${frate} * 60)) % 60]
	set s	[expr int(${FR} / ${frate}) % 60]
	set f	[expr ${FR} % int(${frate})]
set TC [format "%0.2d:%0.2d:%0.2d\-%0.2d" ${h} ${m} ${s} ${f}]
}
}
# set TC [format "%0.2d %0.2d %0.2d\ %0.2d" ${h} ${m} ${s} ${f}]
# set TC [list ${h} ${m} ${s} ${f}]

return ${TC}
}
# end proc
# cclFRl
proc cc2FR {cc} {
global ccrate frate
	return [expr int((${frate} * ${cc}.) / ${ccrate})]
}
# end proc
# FRlccl
proc FR2cc {FR} {
global RATE ccrate frate
	return [expr int((${FR}. / ${frate}) * ${ccrate})]
}
# end proc
# t[[gύX
proc ChangeRATE {rate} {
global MODE RATE frate STATUS LAP Start Stop MaxLap display

	set MODE {watch}

if {${rate}=="next"} then {
catch {
set rate [lindex {RT 24FPS 30NDF 30DF 25FPS} [lsearch -exact {25FPS RT 24FPS 30NDF 30DF} ${RATE}]]
}
if {${rate} == {}} then {set rate RT}
}
	set RATE ${rate}
	switch ${RATE} {
{RT}	{set frate 100.}
{24FPS}	{set frate 24.}
{30NDF}	{set frate 30.}
{30DF}	{set frate 29.97}
{25FPS}	{set frate 25.}
default	{
	set frate ${RATE}
	set RATE "${rate}fps"
	}
	}

	switch ${STATUS} {
{stop}	{set display [FR2TC [cc2FR [expr ${Stop} - ${Start}]]]}
{run\-lap}	{}
{run}	{cc2dp [clock clicks]}
	}
update
	Push_Log "Change RATE\t${RATE}"
return
}

# end proc
proc ChangeMODE {} {
global MODE
	switch ${MODE} {
{watch}	{set MODE {clock}; Push_Log "Change Mode Clock"}
{clock}	{set MODE {watch}; Push_Log "Change Mode Stop-Watch"
update}
	}

}
# end proc

proc update_View {} {
global STATUS Start Stop RATE MODE
global Ri running ccrate frate display

after cancel update_View

set frames [expr int(([clock clicks] - ${Start}) / (${ccrate} / ${frate}))]
	set TC [FR2TC ${frames}]
#		set h [string range ${TC} 0 1]
#		set m [string range ${TC} 3 4]
#		set s [string range ${TC} 6 7]
#		set f [string range ${TC} 9 10]
	regsub ^0 [string range ${TC} 9 10] {}	f


		switch ${MODE} {
{clock}	{cc2dp 0}
{watch}	{
	switch -regexp ${STATUS} {
{^stop$}	{
set display [FR2TC [cc2FR [expr ${Stop} - ${Start}]]]
}
{^run$}	{
	set display ${TC}
	update
}
{^run\-lap$}	{}
default	{}
	}
}
		}

	switch -regexp ${STATUS} {
{run\-lap}	-
{run}	{
set running $Ri([expr int(24 * ${f} / ${frate})])
	update}
default	{}
	}

after 10 update_View

}
# end proc
proc push_LAP {cc} {
global RATE STATUS LAP Start Stop MaxLap display
# TC̏ꍇ 
for {set n [expr ${MaxLap} - 1]} {${n} > 0} {incr n -1} {
	set LAP(${n}) $LAP([expr ${n} - 1])
}
	set LAP(0) [FR2TC [cc2FR [expr ${cc} - ${Start}]]]
	set display $LAP(0)
# LOG
	switch ${STATUS} {
{stop}	{set PreFix "Stop"}
{run}	-
{run-lap}	{set PreFix "Lap"}
default	{set PreFix {}}
	}
	Push_Log "${PreFix}\t$LAP(0)"
}
# end proc


proc Start_Stop {} {
	set now [clock clicks]
global Start Stop STATUS RATE MODE
	switch -regexp ${STATUS} {
{^stop$}	{
		set Start [expr ${now} - (${Stop} - ${Start})]
		if ${Stop} then {push_LAP ${now}} else {Push_Log "Start"}
		set STATUS {run}}
{^run$}		{
#		cc2dp [expr ${now} - ${Start}]
		cc2dp ${now}
		set Stop ${now}
		set STATUS {stop}}
{^run\-lap$}	{
		set STATUS {run}}
	}
	switch ${MODE} {
clock	{set MODE watch ;Push_Log "Cheange Mode Stop-Watch"}
watch	{}
	}
}
# end proc
proc Lap_Reset {} {
	set now [clock clicks]
global STATUS RATE Start Stop running Ri
	switch -regexp ${STATUS} {
{^stop$}	{
		cc2dp ${Start}
		if ${Stop} then {push_LAP ${Stop}}
		set Start 0 ; set Stop 0 ; Push_Log "\treset\n"
		set running $Ri(0)}
{^run$}		{
		push_LAP ${now}
		set STATUS {run-lap}}
{^run-lap$}	{
		cc2dp ${now}
		push_LAP ${now}}
	}
}
# end proc
proc Key_Input {key} {
	switch ${key} {
{1}	{ChangeRATE RT}
{2}	{ChangeRATE 24FPS}
{3}	{ChangeRATE 30NDF}
{4}	{ChangeRATE 30DF}
{5}	{ChangeRATE 25FPS}
{Escape}	{Clear_LAP}
{T}	{ChangeMODE}
default	{return}
	}
#puts $key
}
# end proc

proc ClipCopy {key} {
global MODE Log display LAP MaxLap
set data {}
switch ${key} {
{dp}	{if {${MODE} == "watch"} then {set data ${display}} else {return}}
{lap}	{if {$LAP(0) == ""} then {return} else {
		for {set n 0} {${n} < ${MaxLap}} {incr n} {
if {$LAP(${n}) == ""} then {break} else {append data "$LAP(${n})\n"}
		}}
	}
{log}	{set data ${Log}}
default	{return}
}
	clipboard clear
	catch {clipboard append ${data}}
}
# end proc
################ ABOUT Display
proc about {} {
global VER
catch {tk_messageBox -icon info -type ok -title {about NAS(U) StopWatch} -message "
Nekomata Animation System (Unsaported) 
StopWatch $VER
2001.08.16
"}
focus .
}
#

# interface generated by SpecTcl version 1.1 from Z:/bin/src/contclock/cc_ui.ui
#   root     is the parent window for this user interface

proc cc_ui_ui {root args} {
global BackColor ForeColor
	# this treats "." as a special case

	if {$root == "."} {
	    set base ""
	} else {
	    set base $root
	}
    
	frame $base.tmer_frame \
		-background ${BackColor}

	frame $base.toolbox_frame \
		-background #666666

	frame $base.lap_frame \
		-background ${BackColor}

	frame $base.switch_frame

	button $base.toolbox_frame.rate_bt \
		-text RATE \
		-command {ChangeRATE next}
	catch {
		$base.toolbox_frame.rate_bt configure \
			-font {-*-ariel-Medium-R-Normal-*-*-100-*-*-*-*-*-*}
	}

	button $base.toolbox_frame.mode_bt \
		-text MODE \
		-command {ChangeMODE}
	catch {
		$base.toolbox_frame.mode_bt configure \
			-font {-*-ariel-Medium-R-Normal-*-*-100-*-*-*-*-*-*}
	}

	button $base.toolbox_frame.clear_bt \
		-text CLEAR \
		-command {Clear_LAP}
	catch {
		$base.toolbox_frame.clear_bt configure \
			-font {-*-ariel-Medium-R-Normal-*-*-100-*-*-*-*-*-*}
	}

	label $base.rate_view \
		-background ${BackColor} \
		-foreground ${ForeColor} \
		-justify left \
		-textvariable RATE
	catch {
		$base.rate_view configure \
			-font -*-ariel-Medium-R-Normal-*-*-120-*-*-*-*-*-*
	}

	label $base.ri_view \
		-background ${BackColor} \
		-foreground ${ForeColor} \
		-justify right \
		-textvariable running
	catch {
		$base.ri_view configure \
			-font -*-ariel-Medium-R-Normal-*-*-80-*-*-*-*-*-*
	}

	label $base.main_display \
		-background ${BackColor} \
		-foreground ${ForeColor} \
		-justify left \
		-textvariable display
	catch {
		$base.main_display configure \
			-font -*-ariel-Medium-R-Normal-*-*-240-*-*-*-*-*-*
	}

	button $base.start_stop \
		-text START/STOP \
		-command Start_Stop

	button $base.lap_reset \
		-text LAP/RESET \
		-command Lap_Reset
global MaxLap
for {set n 0} {${n} < ${MaxLap}} {incr n} {

	label $base.lapNo${n} \
		-background ${BackColor} \
		-foreground ${ForeColor} \
		-textvariable LAP(${n})
}

	label $base.status_bar \
		-background ${BackColor} \
		-foreground ${ForeColor} \
		-textvariable STATUS


	# Geometry management
#
	grid $base.tmer_frame -in $root	-row 3 -column 1 
	grid $base.toolbox_frame -in $root	-row 1 -column 1  \
		-sticky w
	grid $base.switch_frame -in $root	-row 4 -column 1 
	grid $base.lap_frame -in $root	-row 5 -column 1 


	grid $base.toolbox_frame.rate_bt -in $base.toolbox_frame	-row 1 -column 1  \
		-sticky w
	grid $base.toolbox_frame.mode_bt -in $base.toolbox_frame	-row 1 -column 2  \
		-sticky w
	grid $base.toolbox_frame.clear_bt -in $base.toolbox_frame	-row 1 -column 3  \
		-sticky w
	grid $base.rate_view -in $base.tmer_frame	-row 1 -column 1  \
		-sticky w
	grid $base.ri_view -in $base.tmer_frame	-row 1 -column 3  \
		-sticky e
	grid $base.main_display -in $base.tmer_frame	-row 2 -column 1  \
		-columnspan 3 \
		-sticky w
	grid $base.start_stop -in $base.switch_frame	-row 1 -column 1  \
		-sticky ew
	grid $base.lap_reset -in $base.switch_frame	-row 1 -column 2  \
		-sticky ew


for {set n 0} {${n} < ${MaxLap}} {incr n} {
	if {[expr ${n} < (${MaxLap} / 2)]} then {
	grid $base.lapNo${n} -in $base.lap_frame \
	-row [expr ${n} + 1] -column 1  \
		-sticky e
	} else {
	grid $base.lapNo${n} -in $base.lap_frame \
	-row [expr ${n} + 1 - (${MaxLap} / 2)] -column 2  \
		-sticky e
	}
}


# STATUS-Bar
	grid $base.status_bar -in $root	-row 6 -column 1  \
		-sticky w

# Resize behavior management

	grid rowconfigure $root 1 -weight 0 -minsize 2
	grid rowconfigure $root 2 -weight 0 -minsize 8
	grid rowconfigure $root 3 -weight 0 -minsize 16
	grid rowconfigure $root 4 -weight 0 -minsize 16
	grid rowconfigure $root 5 -weight 0 -minsize 16
	grid rowconfigure $root 6 -weight 0 -minsize 8
	grid columnconfigure $root 1 -weight 0 -minsize 128

	grid rowconfigure $base.tmer_frame 1 -weight 0 -minsize 10
	grid rowconfigure $base.tmer_frame 2 -weight 0 -minsize 2
	grid columnconfigure $base.tmer_frame 1 -weight 0 -minsize 47
	grid columnconfigure $base.tmer_frame 2 -weight 0 -minsize 40
	grid columnconfigure $base.tmer_frame 3 -weight 0 -minsize 79

	grid rowconfigure $base.toolbox_frame 1 -weight 0 -minsize 15
	grid columnconfigure $base.toolbox_frame 1 -weight 0 -minsize 30
	grid columnconfigure $base.toolbox_frame 2 -weight 0 -minsize 30
	grid columnconfigure $base.toolbox_frame 3 -weight 0 -minsize 96

	grid rowconfigure $base.switch_frame 1 -weight 0 -minsize 2
	grid columnconfigure $base.switch_frame 1 -weight 0 -minsize 70
	grid columnconfigure $base.switch_frame 2 -weight 0 -minsize 23

for {set n 1} {${n} <= (${MaxLap} / 2)} {incr n} {
	grid rowconfigure $base.lap_frame ${n} -weight 0 -minsize 2
}
	grid columnconfigure $base.lap_frame 1 -weight 0 -minsize 83
	grid columnconfigure $base.lap_frame 2 -weight 0 -minsize 83

# additional interface code
. configure -background ${BackColor}
bind . <Button-1> Start_Stop
bind . <Button-3> Lap_Reset

bind . <Key> {Key_Input %K}
bind . <Key-space> +Start_Stop
bind . <Key-Return> +Lap_Reset

bind . <Control-c> {ClipCopy dp}
bind . <Control-C> {ClipCopy lap}
bind . <Control-s> {ClipCopy log}
bind . <Control-q> {exit}

bind .start_stop <Enter>	{bind . <Button-1> {}
#			bind . <Button-3> {}
			}
bind .start_stop <Leave>	{bind . <Button-1> +Start_Stop
#			bind . <Button-3> +Lap_Reset
}
bind .lap_reset <Enter> {bind . <Button-1> {}
#			bind . <Button-3> {}
}
bind .lap_reset <Leave> {bind . <Button-1> +Start_Stop
#			bind . <Button-3> +Lap_Reset
}
bind .toolbox_frame <Enter> {bind . <Button-1> {}}
bind .toolbox_frame <Leave> {bind . <Button-1> +Start_Stop}
# bind .toolbox_frame <Button-1> -Start_Stop
# end additional interface code

}

# initMenu
proc init_MENU {} {
# j[`
set M0 {.m0}
	. configure -menu ${M0}
menu ${M0}
	${M0} add cascade -label Option(O)	-menu ${M0}.sub1
#	${M0} add cascade -label Edit(E)	-menu ${M0}.sub2
#	${M0} add cascade -label Option(O)	-menu ${M0}.sub3
	${M0} add cascade -label Special(S)	-menu ${M0}.sub4
set M0_1 ${M0}.sub1
menu ${M0_1} -tearoff no
${M0_1} add command -label {about}	-command about -underline 1
${M0_1} add command -label Clock/Watch	-command ChangeMODE -underline 0
${M0_1} add command -label RT	-command {ChangeRATE RT} -underline 0
${M0_1} add command -label 24fps	-command {ChangeRATE 24FPS} \
	-underline 0
${M0_1} add command -label 30NDF	-command {ChangeRATE 30NDF} \
	-underline 0
${M0_1} add command -label 30DF	-command {ChangeRATE 30DF} -underline 2
${M0_1} add command -label 25FPS	-command {ChangeRATE 25FPS} -underline 1
${M0_1} add command -label Quit	-command exit -underline 0
set M0_4 ${M0}.sub4
menu ${M0_4} -tearoff no
	${M0_4} add command -label {ClearLap}	-command Clear_LAP -underline 5
	${M0_4} add command -label {CopyTime}	-command {ClipCopy dp} -underline 4
	${M0_4} add command -label {CopyLap}	-command {ClipCopy lap} -underline 4
	${M0_4} add command -label {CopyLog}	-command {ClipCopy log} -underline 6
global tcl_platform
if {$tcl_platform(platform) == "unix"} then {} else {
	${M0_4} add command -label {cShow}	-command {console show} -underline 1
	${M0_4} add command -label {cHide}	-command {console hide} -underline 1
}
# j[`I
}


# Allow interface to be run "stand-alone" for testing


	    wm title . "Stop Watch()"
	init_MENU
	    cc_ui_ui .

update
update_View

focus .
