/*
Adobe forums ̋LڃR[h
photoshop CS5ȍ~ 
http://forums.adobe.com/message/4048744?tstart=0

W[c[̃|CgXNvgŎ擾R[h
*/

function getRulerToolLengthAndAngle(){
    var points = [];
    points.start = [];
    points.end = [];
    var desc = new ActionDescriptor();
    var ref = new ActionReference();
    ref.putProperty( charIDToTypeID('Prpr'), charIDToTypeID('RrPt') );
    ref.putEnumerated( charIDToTypeID('Dcmn'), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') );
    desc.putReference( charIDToTypeID('null'), ref );
    var desc = executeAction( charIDToTypeID('getd'), desc, DialogModes.NO );
    if( desc.hasKey( charIDToTypeID('Pts ') ) ){
        var pointList = desc.getList( charIDToTypeID('Pts ') );
        var startPointDesc = pointList.getObjectValue(0);
       
        points.start.push( startPointDesc.getUnitDoubleValue( charIDToTypeID( 'X   ' ) ) );
        points.start.push( startPointDesc.getUnitDoubleValue( charIDToTypeID( 'Y   ' ) ) );
        var endPointDesc = pointList.getObjectValue(2);
        points.end.push( endPointDesc.getUnitDoubleValue( charIDToTypeID( 'X   ' ) ) );
        points.end.push( endPointDesc.getUnitDoubleValue( charIDToTypeID( 'Y   ' ) ) );
       
        var res = {};
        res.toString = function(){ return 'RulerTool Info';};
        var pointA = points.start;
        var pointB = points.end;
        if( pointA[0]<pointB[0] ){
            var a = Math.max(pointA[0],pointB[0])-Math.min(pointA[0],pointB[0]);
            var o = Math.max(pointA[1],pointB[1])-Math.min(pointA[1],pointB[1]);
            var ang = (180/Math.PI) * Math.atan2(o,a);
            if(pointA[1] < pointB[1]){//negative angle
                ang = -ang;
            };
            res.angle = ang.toFixed(1);
        }else{
            var a = Math.max(pointA[1],pointB[1])-Math.min(pointA[1],pointB[1]);
            var o = Math.max(pointA[0],pointB[0])-Math.min(pointA[0],pointB[0]);
            var ang = 180-((180/Math.PI) * Math.atan2(a,o));
            if(pointA[1] < pointB[1]){//negative angle
                ang = -ang;
            };
            res.angle = ang.toFixed(1);
        }
            if( app.preferences.rulerUnits == Units.PERCENT ){
                res.length = "";
            }else{
                var c = Math.sqrt((a*a)+(o*o));
                var length = new UnitValue( c, 'px');
                length.baseUnit = new UnitValue((1/app.activeDocument.resolution),'in');
                switch( app.preferences.rulerUnits ){
                    case Units.PIXELS: res.length = length.as('px').toFixed(2); break;
                    case Units.INCHES : res.length = length.as('in').toFixed(3); break;
                    case Units.CM: res.length = length.as('cm').toFixed(2); break;
                    case Units.MM: res.length = length.as('mm').toFixed(1); break;
                    case Units.POINTS: res.length = length.as('pt').toFixed(1); break;
                    case Units.PICAS: res.length = length.as('pc').toFixed(2); break;
                }
            }
        return res;
    }
}
var info = getRulerToolLengthAndAngle();
if(info != undefined ) alert('The ruler tool angle is: '+info.angle+'\nThe length is: '+info.length);

