/*
 *	ARD2XPS(ARDStream)
 *		ARDファイルをXPS互換テキストにコンバートする
 *		引き数は、ARDデータのテキストストリーム
 *		コンバート失敗時は ""
 */

function ARD2XPS(ARDStream)
{
//データ冒頭のみチェックして明確に違うストリームの場合はエラーを返す
if(! ARDStream.match(/^#TimeSheetGrid\x20SheetData/)){return ""};
//ARDデータをオブジェクト化する。デフォルトの値は、変換時に書きなおすので決め打ち
var myARD={
	"LayerCount":  0,
	"FrameCount": 24,
	"SrcWidth"  :1280,
	"SrcHeight" : 720,
	"PageFrame" : 144,
	"CmpFps"    :  24,
	"SrcAspect" :   1,
	"CmpAspect" :   1,
	"EmptyCell" :   0,
	"CellNames" :[],
	"Cell":[
		[],
		[],
		[],
		[],
		[],
		[],
	]
};
//ラインで分割して配列に取り込み
	myARD.SrcData=new Array();
	if(ARDStream.match(/\r/)){ARDStream=ARDStream.replace(/\r\n?/g,("\n"));};
	myARD.SrcData=ARDStream.split("\n");
//データ走査・モード切替つつパラメータ取得
	var cellIndex=0;
	for (var line=1;line<myARD.SrcData.length;line++){
		if(myARD.SrcData[line]=="")
		{
			continue;//空行スキップ
		}else{
			var myLineData=myARD.SrcData[line].split("\t");
			switch(myLineData[0])
			{
			case "*CommentStart":;
			case "*CommentEnd":dataStatus="Skip"  ;break;
			case "*ParamStart":dataStatus="Param" ;break;
			case "*MapData":;
			case "*MapNumber":;
			case "*ChildLayer":dataStatus="Skip" ;break;
			case "*CellName":dataStatus="Names"  ;break;
			case "*CellDataStart":dataStatus="KeyEntry";
			case "*Cell":cellIndex=myLineData[1];continue;
			case "*CellEnd":continue;
			case "*End":;
			derfault	:dataStatus="end";break;
			}
		}
//	モードにしたがってパラメータ取得
	  switch(dataStatus){
		case "Param":myARD[myLineData[0]]=myLineData[1];break;
		case "Names":if(myLineData[0].match(/^[0-9]+$/)){myARD.CellNames.push(myLineData[1])};break;
		case "KeyEntry":
		myARD.Cell[cellIndex].push([myLineData[0],myLineData[1]])
		case "End":;
	  default :break;
	  }

	}
	var myXps=new Xps(myARD.LayerCount*1,parseInt(myARD.FrameCount));

	myXps.init(parseInt(myARD.LayerCount),parseInt(myARD.FrameCount));

	if(myARD.CmpFps){myXps.framerate=parseInt(myARD.CmpFps)};//
	if(myARD.CellNames){
		for (var lid=0;lid<myARD.CellNames.length;lid++){
			if(myARD.CellNames[lid]){myXps.layers[lid].name=myARD.CellNames[lid]}
		}
	};//
	if(myARD.Cell){
		for(var L=0;L<myARD.CellNames.length;L++){
		  for(var K=0;K<myARD.Cell[L].length;K++){
		    myXps.xpsBody[L+1][parseInt(myARD.Cell[L][K][0],10)-1]=myARD.Cell[L][K][1];//ダイアログラインをよけてキーを配置
		  }
		}
	};//
	if(xUI.errorCode==0){
		myXps.memo="converted from AERemap data";
		return myXps.toString();
	}
	return "";
}

/*
	書式　XPS2ARD(myXPS)
	引数はオブジェクトでも、ストリームでも受け付ける。
	コンバートするXPSをARD互換形式で書き出すことができる。
	文字コードのコンバートは特にしていないので、
	必要なら何か別のコンバート手段を利用してShift-JISに変換されたし。
	
*/
function XPS2ARD(sourceXPS){
//引数がソースであっても処理する。XPSでない場合はfalse
	if(sourceXPS instanceof Xps){var sourceXPS=sourceXPS;}else{
		if((sourceXPS instanceof String)&&(sourceXPS.match(/^nasTIME-SHEET/))){
			var sourceXPS=new Xps();
			if(! sourceXPS.parseXps(sourceXPS)){return false;};
		}else{
			return false;
		}
	}
//sourceXPSからtiming関連タイムラインを抽出
//プロパティをチェックして必要なタイムラインのIDを抽出する
  var myTargetId=[];
  for (var ix=0;ix<sourceXPS.layers.length;ix ++){
	if(sourceXPS.layers[ix].option.match(/(timing|still)/i)){myTargetId.push(ix+1)}
  }

//ARD互換のオブジェクトを作成
var myARD={
	"LayerCount":  0,
	"FrameCount":  sourceXPS.duration(),
	"SrcWidth"  :  sourceXPS.layers[myTargetId[0]].sizeX,
	"SrcHeight" :  sourceXPS.layers[myTargetId[0]].sizeY,
	"PageFrame" :  (xUI)?xUI.PageLength:6*sourceXPS.framerate,
	"CmpFps"    :  sourceXPS.framerate,
	"SrcAspect" :   1,
	"CmpAspect" :   sourceXPS.layers[myTargetId[0]].aspect,
	"EmptyCell" :   0,
	"CellNames" :[],
	"Cell":[]
};
//レイヤ名を組む
//option="timing"のものだけpushしてIDを控える
var myTargetLayers=[];
for(var lid=0;lid<sourceXPS.layers.length;lid++){
//	if(sourceXPS.layers[lid].option=="timing"){}
	if(sourceXPS.layers[lid].option.match(/(timing|still)/i)){
		myTargetLayers.push(lid);
		myARD.CellNames.push(sourceXPS.layers[lid].name);
	}
}
myARD.LayerCount  =myTargetLayers.length;//セルカウントセット
//変換するタイムラインを処理してキー配列を作成
 for(var lid=0;lid<myARD.LayerCount;lid++){
	var buffDataArray=sourceXPS.getNormarizedStream(myTargetLayers[lid]);
	var keyDataArray=[];
//第一フレームセット
	var currentValue=(isNaN(buffDataArray[0]))?0:buffDataArray[0];
	keyDataArray.push([0,currentValue]);
//第二フレーム以降を処理
  for(var fid=1;fid<myARD.FrameCount;fid++){
	var nextValue=(isNaN(buffDataArray[fid]))?0:buffDataArray[fid];
		if(currentValue==nextValue){
//前と同じデータならskip
			continue;
		}else{
//違っていたらカレント更新してキー追加
			currentValue=nextValue;
			keyDataArray.push([fid,currentValue]);
		}
  }
//配列長が1で、かつキーの値が0の場合は空配列をセットする
	if((keyDataArray.length==1)&&(keyDataArray[0][1]==0)){
//alert("oneData :"+[].toString());
	  myARD.Cell[lid]=[];
	}else{
//alert(keyDataArray)
	  myARD.Cell[lid]=keyDataArray;
	}

 }

//コンバートする
myARD.toString=function(){
var resultStream="#TimeSheetGrid SheetData\n";
resultStream+="\n";
resultStream+="*ParamStart\n";
resultStream+="LayerCount\t"+this.LayerCount+"\n";
resultStream+="FrameCount\t"+this.FrameCount+"\n"
resultStream+="SrcWidth\t"  +this.SrcWidth+"\n";
resultStream+="SrcHeight\t" +this.SrcHeight+"\n";
resultStream+="PageFrame\t" +this.PageFrame+"\n";
resultStream+="CmpFps\t"    +this.CmpFps+"\n";
resultStream+="SrcAspect\t" +this.SrcAspect+"\n";
resultStream+="CmpAspect\t" +this.CmpAspect+"\n";
resultStream+="EmptyCell\t" +this.EmptyCell+"\n";
resultStream+="\n";
resultStream+="*CellName\n";
for(var lid=0;lid<this.CellNames.length;lid++){
	resultStream+=lid+"\t"+this.CellNames[lid]+"\n";
}
resultStream+="*CellDataStart\n";
for(var lid=0;lid<this.CellNames.length;lid++){
	resultStream+="*Cell"+"\t"+lid+"\n";
  for (var kid=0;kid<this.Cell[lid].length;kid++){
	resultStream+=nas.Zf(this.Cell[lid][kid][0]+1,4)+"\t"+this.Cell[lid][kid][1]+"\n";
  }
	resultStream+="*CellEnd"+"\t"+lid+"\n";
	resultStream+="\n";
}
resultStream+="*End";
return resultStream;
}
return myARD.toString();
}
/*
	暫定的にXPSストリーム（ソース）で返しているが、オブジェクトのままのほうが良いかもしれない。一考の余地あり？
	この形式で各フォーマットのコンバータを作って一元化したいが、どうよ？
	逆変換も欲しいね。
*/
//end converter

