/*
	nas配下に基礎オブジェクト拡張

基礎オブジェクト群は、基底プロパティの記述に使用するので従来のnas_common.jsよりも先にロードする必要がある
デバッグ終了後は、ロード順位が入れ替わるので注意
または、基底プロパティをオブジェクト化しないメソッドを考慮すること 07-14


単位付きカプセル化オブジェクトでは、演算の際に期待する値を確実に得るためには Object.as(Unit)で明示的に単位を指定すること

*/

//UnitValuで利用可能な単位 px/pixels を与えるとその時点での基底解像度で処理してpointに換算、pxとしての保存は行わない
nas.UNITRegex=new RegExp('^(in|inches|mm|millimeters|cm|centimeters|pt|picas|points|mp|millipoints)$','i');

/*==================================================================================================再利用メソッド*/
nas.UNITString	=function(){return ([this.value,this.type]).join(' ');};
nas.UNITValue	=function(){return this.value;};
nas.UNITAs	=function(myUnit){return nas.decodeUnit(this.toString(),myUnit)};
nas.UNITConvert	=function(myUnit){this.value=nas.decodeUnit(this.toString(),myUnit);this.type=myUnit;return this;};

nas.ANGLEAs	=function(myUnit){
		var targetUnit=(myUnit.match(/^(d|degrees|°|度|)$/))?"degrees":"radians";
		if(targetUnit==this.type){
			return this.value
		}else{
			return (targetUnit=="degrees")? radiansToDegrees(this.value):degreesToRadians(this.value);
		}
	};
nas.ANGLEConvert=function(myUnit){
		var targetUnit=(myUnit.match(/^(d|degrees|°|度|)$/))?"degrees":"radians";
		this.value=(targetUnit=="degrees")? radiansToDegrees(this.value):degreesToRadians(this.value);
		this.type=targetUnit;
		return this;
	};

nas.RESOLUTIONAs	=function(myUnit){
		var targetUnit=(myUnit.match(/^(dpi|ppi|lpi|dpc|ppc|lpc)$/i))? RegExp.$1:'dpi';
		if(targetUnit.slice(1)==this.type.slice(1)){
			return this.value
		}else{
			return (targetUnit.indexOf('pc')<0)? this.value*2.540:this.value/2.540;
		}
	};
nas.RESOLUTIONConvert=function(myUnit){
		var targetUnit=(myUnit.match(/^(dpi|ppi|lpi|dpc|ppc|lpc)$/i))? RegExp.$1:'dpi';
		this.value=(targetUnit.indexOf('pc')<0)? this.value*2.540:this.value/2.540;
		this.type=targetUnit;
		return this;
	};

nas.LISTString=function(myUnit){
		if(typeof myUnit == "unidefined"){myUnit=false;}
		var myResult=[];
		for(var myDim=0;myDim<this.length;myDim++){
		  if(myUnit){
			myResult.push(this[this.props[myDim]].as(myUnit));
		  }else{
			myResult.push(this[this.props[myDim]].toString());
		  }
		}
		return myResult.join();//リスト文字列で
	};
nas.ARRAYValue	=function(myUnit){
		if(typeof myUnit == "unidefined"){myUnit=false;}
		var myResult=[];
		for(var myDim=0;myDim<this.length;myDim++){
		  if(myUnit){
			myResult.push(this[this.props[myDim]].as(myUnit))
		  }else{
			myResult.push(this[this.props[myDim]].value)
		  }
		}
		return myResult;//配列で
	};
/*=================================================================================================================*/
/*
	nas.UnitValue Object
コンストラクタ:
	new nas.UnitValue("値"[,"単位"]);
引数:	値　String 単位つき文字列または数値文字列
	単位 String 単位を文字列で

単位が指定されない場合は第一引数の単位を使用、異なる場合は第一引数の値を第二引数の単位へ変換してオブジェクト化する
どちらも無効な場合は、第一引数の数値部分をインチで換算 (Adobe Extend Script 準拠)
有効な単位は	in,inches,mm,millimeters,cm,centimeters,pt,picas,points,mp,millipoints

オブジェクトメソッド：

nas.UnitValue.as("単位文字列")	指定された単位文字列に変換した数値を返す
nas.UnitValue.convert("単位文字列")	指定された単位文字列にオブジェクトを変換する 変換後の単位付き数値文字列を返す

*/
nas.UnitValue=function(myNumberString,myUnitString){
	if(typeof myNumberString == "string"){
		var myNumberUnit=myNumberString.replace(/[\.\s0-9]/g,'')
	}else{
		var myNumberUnit='';
		myNumberString=new String(myNumberString);
	};
	if(arguments.length<2){myUnitString=myNumberUnit;}
	if(!(myUnitString.match(nas.UNITRegex))) myUnitString="in";
	this.value=(myNumberUnit=='')?parseFloat(myNumberString):nas.decodeUnit(myNumberString,myUnitString);
//	this.value=parseFloat(myNumberString);
//ESTK　互換時はこちら↑すこし運用して考える…が、この動作はなんかBUGっぽいのでコンバートのほうが良いと思う
//	this.value=nas.decodeUnit(myNumberString,myUnitString);
	this.type=myUnitString;
}

nas.UnitValue.prototype.as	=nas.UNITAs;
nas.UnitValue.prototype.convert	=nas.UNITConvert;
nas.UnitValue.prototype.toString=nas.UNITString;
nas.UnitValue.prototype.valueOf	=nas.UNITValue;

/*	nas.UnitAngle
コンストラクタ	nas.UnitAngle("値"[,"単位"])
引数:	値	Number or String 単位付き数値または数値
	単位	 String 単位文字列省略可能

使用可能な値は　/^(d|degrees|°|度|)$/)
指定値以外または単位なしで初期化された場合は radians
単位変換機能付き
例:	A=new nas.UnitAngle("180 degrees","radians");//	180度相当の値がラディアンで格納される
	A=new nas.UnitAngle(1);//1 rad
	A=new nas.UnitAngle("27.4 d");//27.4 degrees　として格納

オブジェクトメソッド:
nas.UnitAngle.as("単位文字列")	指定された単位文字列に変換した数値を返す
nas.UnitAngle.convert("単位文字列")	指定された単位文字列にオブジェクトを変換する 変換後の単位付き数値文字列を返す

*/
nas.UnitAngle=function(myNumberString,myUnitString){
	if(! myUnitString){myUnitString=myNumberString.replace(/[\.\s0-9]/g,'')};
	if(myUnitString.match(/^(d|degrees|°|度|)$/)){myUnitString='degrees'}else{myUnitString='radians';};
	this.value=parseFloat(myNumberString);
	this.type=myUnitString;
}

nas.UnitAngle.prototype.as	=nas.ANGLEAs;
nas.UnitAngle.prototype.convert	=nas.ANGLEConvert
nas.UnitAngle.prototype.toString=nas.UNITString;
nas.UnitAngle.prototype.valueOf	=nas.UNITValue;

/*
	nas.UnitResolution Object
コンストラクタ　単位付き解像度オブジェクト
	new nas.UnitResolution("解像度"[,"単位"])

引数:	解像度　String or Number 単位付き文字列または数値
	単位	String	単位を文字列で
	双方が異なっていれば指定単位に換算
	指定可能な単位は (/dpi|ppi|lpi|dpc|ppc|lpc/i)　実質は2種　デフォルトは dpc

例:	new Resolution('120dpi','dpc');
	new Resolution( 50,'dpc');
	new Resolution('200 dpi');

オブジェクトメソッド:
nas.UnitResolution.as("単位文字列")	指定された単位文字列に変換した数値を返す
nas.UnitResolution.convert("単位文字列")	指定された単位文字列にオブジェクトを変換する 変換後の単位付き数値文字列を返す

*/
nas.UnitResolution=function(myNumberString,myUnitString){
	if(typeof myNumberString == "string"){
		var myNumberUnit=myNumberString.replace(/[\.\s0-9]/g,'')
	}else{
		var myNumberUnit='dpc';
		myNumberString=new String(myNumberString);
	};
	if(arguments.length<2){myUnitString=myNumberUnit;};
	if(! (myUnitString.match(/^(dpi|ppi|lpi|dpc|ppc|lpc)$/i))){myUnitString='dpc'};
	this.value=(myUnitString==myNumberUnit)?parseFloat(myNumberString):
	(myUnitString.indexOf('pc')<0)?parseFloat(myNumberString)*2.540:parseFloat(myNumberString)/2.540;
	this.type=myUnitString;
}
nas.UnitResolution.prototype.as		=nas.RESOLUTIONAs;
nas.UnitResolution.prototype.convert	=nas.RESOLUTIONConvert;
nas.UnitResolution.prototype.toString	=nas.UNITString;
nas.UnitResolution.prototype.valueOf	=nas.UNITValue;


/*================================  以下は単位付き数値オブジェクトを要素に持つ複合オブジェクト===============*/
/*
	座標オブジェクト
コンストラクタ:
	new nas.Position(x[,y[,z]])
1次元、2次元、3次元の値が初期化可能
引数は UnitValueまたは文字列で

第一引数の持つ単位を、代表単位として保存するが、オブジェクトの生成後に他の単位を設定することが可能

または
	new nas.Position(nas.Position)
第一引数がnas.Position　オブジェクトだった場合は、そのオブジェクトの複製を初期化する

または
	new nas.Position(値リスト/配列[,単位])
値リストでの初期化も可能　多くの実装で配列形式の座標を扱うので互換をもたせるものとする


Position.dimension　で次数が取得できる

プロパティはUnitValue
引数が数値ならばptとして初期化する
与えられない次数のプロパティは0として扱うことが可能
引数なしの場合は2次元["0pt","0pt"]で初期化される

	プロパティ
nas.Position.length	Int　整数　保持している値の次数
nas.Position.x	UnitValue x座標値
nas.Position.y	UnitValue y座標値
nas.Position.z	UnitValue z座標値
nas.Position.type String 単位

数値で値を得る場合は各プロパティのas()メソッドを使用のこと

例： [myPosition.x.as('pt'),myPosition.y.as('pt')]

オブジェクトメソッド:
nas.Position.toString([指定単位])	;指定単位に揃えてリストで返す
nas.Position.valueOf([指定単位])	;指定単位にそろえて配列を戻す
単位指定がない場合は、登録された単位で返す

*/
nas.Position=function(x,y,z){
	if(arguments.length==0){
		arguments[0]=new nas.UnitValue('0 pt');
		arguments[1]=new nas.UnitValue('0 pt');
	}
	this.length=arguments.length;//DimensionLength
	this.props=['x','y','z'];
	for(var myDim=0;myDim<this.length;myDim++){
	  if(arguments[myDim] instanceof nas.UnitValue){
	    this[this.props[myDim]]  =arguments[myDim];
	  }else{
	    this[this.props[myDim]]  =new nas.UnitValue(arguments[myDim]);
	  }
	}
	this.type=this.x.type;
}
nas.Position.prototype.toString=nas.LISTString;
nas.Position.prototype.valueOf =nas.ARRAYValue;
/*
	 オフセットオブジェクト
オフセットを利用するための複合オブジェクト
positionとorientationを組み合わせたもの
初期化の引数は位置オブジェクトと方向オブジェクトで
*/
nas.Offset=function(myPos,myOrt){
	this.position=myPos;
	this.orientation=myOrt;
	this.x=this.position.x;
	this.y=this.position.y;
	this.r=this.orientation.rotationZ;
}
/*
	ベクトルオブジェクト
コンストラクタ:
	new nas.Vector(p1[,p2][,単位])
1次元、2次元、3次元の値が初期化可能
引数は	始点・終点　/nas.Position
	単位文字列

引数の次元のうち次数の高い方に合わせたVectorを初期化する
Vector.dimension　で次数が取得できる
単位文字列が指定されなかった場合は、始点の単位を使用する

プロパティは　nas.Position
与えられない次数のプロパティは0として扱う

引数なしの場合はデフォルトの単位値で２次元の単位ベクトルを戻す

	プロパティ

nas.Vector.dimension	Int　整数　保持している値の次数1～3
nas.Vector.origin	Position 始点座標
nas.Vector.value	Position ベクトル値(=終点座標-始点座標)
nas.Vector.type	String　単位文字列

オブジェクトメソッド:
nas.Vector.toString([指定単位])	;指定単位に揃えてリストで返す
nas.Vector.valueOf([指定単位])	;指定単位にそろえて配列を戻す

*/
nas.Vector=function(startPoint,endPoint){
	if(arguments.length==0){
		this.dimension=2;
		this.origin=new nas.Position('0 pt','0 pt');
		this.value=new nas.Position('1 pt','1 pt');
		this.type="pt";
	}else{
		this.dimension=(startPoint.length>endPoint.length)?startPoint.length:endPoint.length;
		this.type=startPosition.type;
		if(this.dimension>startPoint.length){
			startPosition=new nas.Position((startPoint.toString(this.type)+',0,0').split(',').slice(0,this.dimension),this.type);
		}
		this.origin=new nas.Position(startPosition.valueOf(this.type))
		this.value=new nas.Position(startPosition.valueOf(this.type))
	}
	this.type=arguments[0].type;//DimensionLength
	this.origin=arguments[0];
	this.props=['origin','value'];
	for(var myDim=0;myDim<this.length;myDim++){
	  if(arguments[myDim] instanceof nas.UnitValue){
	    this[this.props[myDim]]  =arguments[myDim];
	  }else{
	    this[this.props[myDim]]  =new nas.UnitValue(arguments[myDim]);
	  }
	}
}
nas.Vector.prototype.toString=nas.LISTString;
nas.Vector.prototype.valueOf =nas.ARRAYValue;
/*
	回転オブジェクト
	引数一つで初期化された場合は、ｚ軸回転
	それ以上の場合は、3軸の回転となる
	回転の解決順は z-y-x
コンストラクタ
	new nas.Rotation([x,y,] z)
引数はUnitAngleまたは文字列

*/
nas.Rotation=function(){
	if(arguments.length==0){
		arguments[0]=new nas.UnitAngle('0 radians');//記述がない場合はz軸のみで初期化
	}
	this.length=arguments.length;//DimensionLength
	this.props=["rotationX","ritationY","rotationZ"];
	if(this.length==1){
	  this.rotationZ=(arguments[0] instanceof nas.UnitAngel)? arguments[0]:new UnitAngle(arguments[0]);
	  this.rotationY=new nas.UnitAngle('0 radians');
	  this.rotationX=new nas.UnitAngle('0 radians');
	}else{
	  for(var myDim=0;myDim<this.length;myDim++){
	    if(arguments[myDim] instanceof nas.UnitAngle){
	      this[this.props[myDim]]=arguments[myDim];
	    }else{
	      this[this.props[myDim]]=new nas.UnitAngle(arguments[myDim]);
	    }
	  }
	}
}
nas.Rotation.prototype.toString=nas.LISTString;
nas.Rotation.prototype.valueOf =nas.ARRAYValue;

/*
	方向オブジェクト
	引数一つで初期化された場合は、ｚ軸指定
	それ以上の場合は、3軸指定となる
	回転の解決順は z-y-x
コンストラクタ
	new nas.Orientation([x,y,] z)
引数はUnitAngleまたは文字列

*/
nas.Orientation=function(){
	if(arguments.length==0){
		arguments[0]=new nas.UnitAngle('0 radians');//記述がない場合はz軸のみで初期化
	}
	this.length=arguments.length;//DimensionLength
	this.props=["orientationX","orientationY","orientationZ"];
	if(this.length==1){
	  this.rotationZ=(arguments[0] instanceof nas.UnitAngel)? arguments[0]:new UnitAngle(arguments[0]);
	  this.rotationY=new nas.UnitAngle('0 radians');
	  this.rotationX=new nas.UnitAngle('0 radians');
	}else{
	  for(var myDim=0;myDim<this.length;myDim++){
	    if(arguments[myDim] instanceof nas.UnitAngle){
	      this[this.props[myDim]]=arguments[myDim];
	    }else{
	      this[this.props[myDim]]=new nas.UnitAngle(arguments[myDim]);
	    }
	  }
	}
}
nas.Orientation.prototype.toString=nas.LISTString;
nas.Orientation.prototype.valueOf =nas.ARRAYValue;

/*	フレームレートオブジェクト
コンストラクタ
	new nas.Framerate(rateString[,rate])
引数:	reteString String フレームレート文字列
	rate Number 省略可能　実フレームレート
	フレームレート文字列は任意　24FPS 25FPS等の\dFPS の場合はその数値を利用
	またはキーワード SMPTE(NDF),SMPTE60(NDF),SMPTE24NDF　で各 30/1.001 60/1.001 24/1.001 をセットする
	NDFをキーワードに含む場合はNDFコードを使用する
	フレームレート文字列に数値が含まれているかまたはキーワードの場合は、第二引数を省略可能
	不正な引数で初期化された場合は、クラスプロパティを使用する
*/
nas.Framerate={name:"24FPS",rate:24};

nas.Framerate.toString=function(){return this.name;}
nas.Framerate.valueOf=function(){return this.rate;}
nas.newFramerate=function(rateString,rate){
	var newOne=Object.create(nas.Framerate);
	if(arguments.length){
	  if(arguments.length>1){
	    newOne.name=rateString;
	    newOne.rate=parseFloat(rate);
	  }else{
	      newOne.name=rateString;
	    if(rateString.indexOf('SMPTE')>=0){
	      switch(rateString){
	case "SMPTE24":    newOne.rate=24/1.001;break;
	case "SMPTE60":
	case "SMPTE60NDF": newOne.rate=60/1.001;break;
	default	:          newOne.rate=30/1.001;break;
	      }
	    }else{
	      newOne.rate=parseFloat(rateString);
	    }
	  }
	}
	if(!(newOne.rate)){delete newOne.rate;delete newOne.name;}
	return newOne;
}

/*
	サイズオブジェクト
コンストラクタ
	new nas.Size(width,height[,depth])
引数は
	UnitValue	/	width,height,depth
	TimingCurve	/	timing	
引数がない場合は単位"pt"でサイズ0　二次元 curve＝リニア　のオブジェクトを初期化
Rectangle
	width
	height

コンストラクタでタイミングカーブを初期化する必要は無いのでヤメ
*/

nas.Size=function(myWidth,myHeight,myDepth,myTiming,myCurve){
	if(arguments.length==0){
		arguments[0]=new UnitValue("0 pt");
		arguments[1]=new UnitValue("0 pt");
	}
//	this.prptotype=nas.Vector.prototype;
	this.length=arguments.length;//DimensionLength
	this.props=["width","height","depth"];
	for(var myDim=0;myDim<this.length;myDim++){
	
	  this[this.props[myDim]]  =new nas.UnitValue(arguments[myDim]);
	}

	this.toString=function(){
		var myResult=[];
		for(var myDim=0;myDim<this.length;myDim++){myResult.push(this[this.props[myDim]].value)}
		return myResult;
	};
	this.valueOf=function(){
		var myResult=[];
		for(var myDim=0;myDim<this.length;myDim++){myResult.push(this[this.props[myDim]].value)}
		return myResult;
	};
}
nas.Size.prototype.toString=nas.LISTString;
nas.Size.prototype.valueOf =nas.ARRAYValue;
//nas.Size.prototype.timing="linear";//undefinedで良い
/* 
Position（座標）クラス
Vectorオブジェクト


1次元のVevtorはbool / 2次元のVectorは 1次元のOrientation（Z）/ 3次元のVeltorは 3次元のOrientation (XYZ)を持つ
プロパティで持たせるか、またはラムダ関数で導くか？　アクセス頻度？

*/
/*
Curve　Object
new nas.Curve(point1,point2,isAbs)
アークを指定するための複合Object
座標系のObjectに持たせるcurveプロパティの値
自分自身の座標を始点としてベジェの第一制御点と第二制御点を相対座標で持たせる
終点はタイムシート上に次に出現する値
したがって次の区間に値が存在しない場合は、指定自体が意味を失う
指定が絶対座標であった場合は、 親オブジェクト側で座標系の変換を行い相対座標にして格納する
カーブデータを必要とする区間は、直前の区間のカーブ値と直後の区間の値を参照する。
値を持っていてもカーブプロパティを持たないエントリがあっても良い
その場合は、標準値で補う
C=new Curve( new Point(0,0),new Point(1,1))
*/
nas.Curve=function(p1,p2){
	this.ctrpt1=p1;
	this.ctrpt2=p2;
//	this.
//	this.
}
/*
　TimingCurve　Object
　タイミング指定をするための配列ベースのObject
値を持つObjectに全て持たせることが可能
始点を[0,0] 終点を[1,1]と置いて第一制御点と第二制御点を少数値で与える
値範囲は0-1に限定する。
キーワード文字列で初期化された場合、ライブラリ内にキーワードに対応する値が存在するならテキストを値として実際の値はクラスライブラリを参照する。
タイミングを解決するのは、値を持ったObjectの直後の中間値補間区間

T=new TimingCurve("linear"); //	戻値[[0,0],[1,1]]
*/
nas.TimingCurve=function(){
//	this.
}
/*
nas.AnimationPeg Object
nasペグシステムでサポートするペグオブジェクト

以下のペグをサポートする
0:表示のないペグ　角合せ及び中央合せ	中央合わせがデフォルト値
	0:中央合せ
	1:左下合せ(ステージ第一象限)
	2:左上合せ(ステージ第二象限)
	3:右上合せ(ステージ第三象限)
	4:右下合せ(ステージ第四象限)
	5:他任意の位置
	プリセットで色々作る
　各ポイントは、ペグ（レジストレーション点）として扱う
	可視、不可視の属性を持ち、外見プロパティを持たせることができる。
	外見プロパティの登録がない場合簡易表示として、レジストリシンボルを使う
　エレメントグループ内部のみで角合わせを行うとレジストレーション点が画面中央で初期化されたりするが通常の動作である
　必要に従って、新たなタップを作成（ステージにタップ＝カメラワークフレームを設定＝設置）して其処にジオメトリネットワークを構築する
　実物線画台と異なり同じ位置にもタップが置ける

外見プロパティは以下から選択できるように設定
0:不可視、表示の際はシンボルで
1:ACME	ACME があれば問題ないと思う
2:丸あな2穴	穴径及び間隔は別に設定　またはシンボル
3:丸あな3穴	タイプはASAのみ用意する　ほかはいらん

ペグ（レジストレーション）システムとして考えた場合　角合せも中央整列もペグの位置指定と同じ
フレームからのレジストレーション点オフセットのデータ書式は同じ　→　ケースわけしない
レジストレーション代表点は、ペグの場合各ペグの中心（ACMEならセンターホール中心）、０番系列はポイントそのもの
向きはエレメントグループ内で揃っていれば同じ
データ上のオフセットは、レジストリ点のローカル座標とローテーション
pegオフセットは、フレーム中心からのペグ（レジストレーション点）のオフセットとローテーション

したがってフレーム中心のローカル座標は　sub(offset,pegOffset)となる。

基本構成は同じだが、AnimationPegはオブジェクトでなく　AnimationFrameオブジェクトのプロパティとして実装してそのプロパティの一部としてPegFormを設定する。
これがペグの外形を保持するように実装

オフセットプロパティ群の関連は以下のリスト

 GeometryOffset　オブジェクト　基底クラスオブジェクト
 位置オフセット+回転（オリエンテーション）値で成立する　回転に際して正規化が発生する

offset
	セルエレメントのローカル座標内のペグ位置オフセット
pegOffset
	プロパティとしては親座標系内のペグ位置
	デフォルトで使う限りは親がステージなのでワールド座標系での位置になる
	ネットワーク構築時のネスト時の親に注意
	乗り換え操作の際は、一旦ステージまでさかのぼってコンバートする方針で実装
frameOffset
	ペグ位置に対するフレームのオフセット
	エレメント（ローカル）座標系で記録する
*/
nas.GeometryOffset=function(myPoint,myRotation){
	this.position=myPoint;
	this.x=this.position.x;
	this.y=this.position.y;
	this.rotation=myRotation;
	this.r=this.rotation.rotationZ;
}
/*
nas.AnimationFrame Object
作画アニメーションフレームを保持するオブジェクト
クリッピングフレーム（カメラワークオブジェクト）の基底クラス
10インチ標準フレームは、new nas.AnimationFrame("10inSTD",720,16/9,[[0,"105mm"],0])
*/
nas.AnimationFrame=function(myName,baseWidth,frameAspect,pegOffset){
	this.name=myName;
	this.baseWidth=baseWidth;
	this.frameAspect=frameAspect;
	this.scale=1.0;
	this.peg=myPeg;
	this.pegOffset=pegOffset;
}
/*
nas.ClippingFrame Object
クリッピングフレーム、撮影指定として機能する実画像を持たないオブジェクト
参照データとして外部データへのリンクを保持できる
カメラワークトラックセクションの値となる
*/
nas.ClippingFrame=function(myIndex,myGroup,myName,baseWidth,frameAspect,pegOffset){
	this.id=myIndex;
	this.group=myGroup;
	this.name=myName;
	this.referenceSource;
	this.resolution;
	this.size;
	this.position;
	this.rotaion;
	this.offset;
	this.offsetRotation;
	this.pegOffset;
	this.pegRotaion;
	this.comments;	
}

/*
nas.AnimationReplacement Object
Map上のセルエントリ・タイムシートの置きかえトラックの値になる　外部リンクを保持するオブジェクト
リプレースメントオブジェクト
*/
nas.AnimationReplacement=function(myIndex,myGroup,myName){
	this.id=myIndex;
	this.group=myGroup;
	this.name=myName;
	this.source;
	this.resolution;
	this.size;
	this.position;
	this.rotation;
	this.offset;
	this.offsetRotation;
	this.pegOffset;
	this.pegRotation;
	this.comments;
}
/*
nas.AnimationSound Object
タイムシートサウンドトラックの値となる　外部リンクを保持するオブジェクト
*/
nas.AnimationSound=function(myIndex,myGroup,myName){
	this.id=myIndex;
	this.group=myGroup;
	this.name=myName;
	this.source;
	this.duration;
	this.contentText;
	this.startOffset;
	this.comments;
}

/*
nas.AnimationComposit
コンポジット、合成指定として機能する画像コンポジットオブジェクト
エフェクトトラックセクションの値から導かれて再構成に利用される
参照外部リンクは持たない
*/
nas.AnimationComposit=function(myIndex,myGroup,myName){
	this.id=myIndex;
	this.group=myGroup;
	this.name=myName;
	this.source;
	this.duration;
	this.contentText;
	this.startOffset;
	this.comments;
}
/*
nas.AnimationEffect
コンポジット、合成指定として機能する画像エフェクトオブジェクト
エフェクトトラックセクションの値となる
内部的にCompositeオブジェクトで構成される
参照外部リンクを持つ（参照用画像）
 */
nas.AnimationEffect= function (myIndex,myGroup,myName){
	this.id=myIndex;
	this.group=myGroup;
	this.name=myName;
//	this.referenceSource;
//	this.opacity;
//	this.compositMode;
	this.comments="";
}
/*
var A=new nas.UnitValue("12cm");
var B=new nas.UnitValue("12cm");

A+B
*/

/*
time?
frames?
nas.movieFrames
framerate
画像オブジェクトのプロパティは
Offset Object

原点座標は　左下
タップが含まれないエントリの原点オフセットは　画像データの中央（標準オフセット）
タップがある場合は、原点オフセットはタップの配置を勘案して導かれる。

セルオブジェクトは以下のプロパティを持つ
property	value
Cell.size	nas.Size 
	エントリのサイズ　クリッピングフレームを表す大きさ
	クリッピングサイズに満たない部分はコンポジット中性値で補われる
	クリッピングサイズをはみ出すデータはスイッチで挙動を変える
Cell.offset	nas.Offset
	コンポジット時に参照される原点オフセット
	ペグが有効な場合は、ペグから算出
	直接値が与えられた場合はその値を使用する　
Cell.peg.Offset	nas.Offset
	
Cell.peg	nas.Peg


Composite　　Object
blendingMode

*/
