﻿/*	3Dレイヤの現在の表示サイズを%で表示
 *	3Dレイヤに"スライダ制御"を作って適用すると、
 *	Z値 0px時を100%とする見た目のサイズが比率(%)で得られる。
 *	特に制御等はしないが、パーセントで撮影指定された
 *	スケーリングを３Ｄレイヤで処理するときの確認に使える。
 */
var AE5=false;//AE6以降ならfalse AE5-5.5はtrue
//デフォルトカメラの値を設定(推測ナノデはずれてたら御免)
if(AE5){
//AE5xデフォルトカメラ
	var myZoom=Math.tan(degreesToRadians((180-46.7900)/2))*(Math.sqrt(Math.pow(thisComp.height,2)+Math.pow(thisComp.width,2))/2);
	var cameraPosition=[thisComp.width/2,thisComp.height/2,-myZoom];
}else{
//AE6以降のデフォルトカメラ
	var myZoom=Math.tan(degreesToRadians((180-39.5980)/2))*(thisComp.width/2);
	var cameraPosition=[thisComp.width/2,thisComp.height/2,-myZoom];
}
//レイヤにカメラがあるかチェックする
var hasCamera=false;
for(idx=1;idx<=thisComp.numLayers;idx++){
	if((thisComp.layer(idx) instanceof Camera)&&(thisComp.layer(idx).active)){hasCamera=true;break;}else{continue;}
}
//カメラレイヤがあればアクティブカメラを使う(アクティブカメラがない場合はエラー)
if(hasCamera){
	myZoom=thisComp.activeCamera.zoom;
	cameraPosition=thisComp.activeCamera.position;
}
//視点からレイヤまでの距離を出して比の逆数で計算
var baseDistance=length(cameraPosition,[thisComp.width/2,thisComp.height/2,0]);//カメラ位置から標準レイヤ位置まで距離
var anchorOffset=sub(this.anchorPoint,[this.width/2,this.height/2,0]);//アンカーポイントによるレイヤのオフセット量

//zoom動作とanchorオフセットを考慮した計算
(myZoom/baseDistance)*100*baseDistance/length(sub(sub(this.position,anchorOffset),cameraPosition));
