﻿/**
 *	汎用的に隣接するキーを求める関数　AEエクスプレッション専用
 *	戻り値は nearestKey(t) と互換にする（キーを直接返す）
 *	キーが存在しない場合オリジナルのnearestKeyはエラー終了するがこの関数はnullを返す
 *	@params	{Number} tm time float
 *	@params	{String} order 並び順　none|pre|post derfalult 'pre'
 *	@params	{Object} target 検索対象トラック
 *	@returns {Object Keyframe|null} キーフレーム　または　null
 */
function getNearestKey(tm,order,target){
	if(! tm)	tm		= time;
	if(! order)	order	= 'pre';
	var targetProp=(target)?target:thisProperty;
	//var Result;
	var maxIndex = targetProp.numKeys;
	if (maxIndex == 0) {
		return null;
	}else{
		nKey = targetProp.nearestKey(tm);
// 引数tmと比較して前キーの値と後ろキーのインデックスを求める。最少キーの前と最終キーの後ろは前後キーに同じ値を代入
		if( tm >= nKey.time ) {
			var preIndex = nKey.index;var postIndex = nKey.index + 1;
			if(postIndex > maxIndex){postIndex = maxIndex}
		}else{
			var postIndex = nKey.index;var preIndex = nKey.index - 1;
			if(preIndex == 0){preIndex = 1}
		}
		if(preIndex == postIndex) {
			return nKey;
		} else if(order == 'pre'){
			return targetProp.key(preIndex);
		} else if(order == 'post'){
			return targetProp.key(postIndex);
		} else {
			return nKey;
		}
	}
}
/* TEST 整数値を受け入れるプロパティに対して使用のこと */
	var sample = getNearestKey(time,'pre');
	sample.index;
	