#!/bin/sh
# Restart Tcl/TK \
exec tclsh "$0" "$@"
#
#	Ctotal.tcl
#
set VER {1.0}
#
#
# ѿ
set ID	0
#Record(${ID})	{CUTNo TIME}
#PageName(${Page})
#PageTOTAL(${PAGE})
#subTOTAL(ID)
set TOTAL {0}
set RATE	{24}
set PageMAX	{5}
# ¸ե
set DataFile	{total.txt}
# ޥɲ
proc usage {} {

global VER
global tcl_platform
puts "
usage: Ctotal \[options\]\.\. \[<FileName>\]\.\.
-------------------------------------------------------
args:
	<FileName>		SaveFileName\(plain-text\)
options:
	-r<RATE>		set FrameRate
	-c<COLUMNS>		set PageColumns
	-h			show this message
-------------------------------------------------------
program Version :\t$VER
platform :\t$tcl_platform(platform)
"
}
# åֹι
proc IncrCut {CUT} {
	switch -regexp ${CUT} {
{[^0-9]}	{regsub -all {[^0-9]} $CUT {} NUM}
default	{set NUM ${CUT}}
	}
regsub {^0+} ${NUM} {} NUM
return [expr ${NUM} + 1]
}
proc TC2FR {TC} {
global RATE
	set TC [split ${TC} \+]
	set s [lindex ${TC} 0]
	set f [lindex ${TC} 1]
return [expr $s * ${RATE} + $f]
}

proc FR2TC {FR} {
global RATE
	set h	[expr (${FR} / (${RATE} * 3600)) % 100]
	set m	[expr (${FR} / (${RATE} * 60)) % 60]
	set s	[expr (${FR} / ${RATE}) % 60]
	set f	[expr ${FR} % ${RATE}]
return [format "%0.2d:%0.2d:%0.2d\+%0.2d" ${h} ${m} ${s} ${f}]

}
# Ϥ
proc RegTC {INPUT} {
global RATE
	set TC [split ${INPUT} \+]
	set s [lindex ${TC} 0]
	set f [lindex ${TC} 1]
#	regsub {^0+} [lindex ${TC} 0] {} s
#	regsub {^0+} [lindex ${TC} 1] {} f
	set frames [expr $s * ${RATE} + $f]
	set s [expr ${frames} / ${RATE}]
	set f [expr ${frames} % ${RATE}]
return "${s}+${f}"
}

# Ϥ򽦤
proc GetInput {message} {
	puts -nonewline "\n${message}\ \ --> "

regsub {\-} [gets stdin] {\\-} result

	switch -regexp "${result}" {
	{^[a-z\\].*$}	-
	{^$}	{return ${result}}
	{^[0-9]+[\+\,\.\-][0-9]+$}	{
		regsub {[\+\,\.\-]} ${result} {+} result
		return ${result}
	}
	{^[0-9]+[\+\,\.\-]$}	{
		regsub {[\+\,\.\-]} ${result} {+0} result
		return ${result}
	}
	{^[\+\,\.\-][0-9]*$}	{
		regsub {[\+\,\.\-]} ${result} {0+} result
		return ${result}
	}
	{^[0-9]+$}	{
		set result "${result}\+0"
		return ${result}
	}
	default	{GetInput ""}
}
}
###
proc Read {} {
global Record PageMAX ID PageName
global DataFile
#puts [pwd]
#puts [glob *]
	if [file exists ${DataFile}] then {

if [array exists Record] then {unset Record}
if [array exists PageName] then {unset PageName}

set R [open ${DataFile} r]
#PageMAX
	set oPname {}
	set CCount {1}
	while 1 {
	if [eof $R] then {break}
	gets ${R} LINE
	switch -regexp ${LINE} {
{^\#.*} {continue}
default {
	set Pname [lindex ${LINE} 1]
	if {${Pname} == ${oPname}} then {incr CCount
	} elseif {${oPname} == {}} then {set oPname ${Pname}
	} else {break}
}
	}
	}
	if {${CCount} >= 1} then {set PageMAX ${CCount}}
	seek ${R} 0 start
#ɤ߽Ф
	while 1 {
	if [eof $R] then {close $R ;return}
	gets ${R} LINE
	switch -regexp ${LINE} {
{^$}	-
{^\#.*}	{continue}
default	{
	set ID [lindex ${LINE} 0]
		regsub {^0+} ${ID} {} ID
		if {${ID} == {}} then {set ID {0}}
	set Page [lindex ${LINE} 1]
	set Column [lindex ${LINE} 2]
	set Cut [lindex ${LINE} 3]
		regsub {^C\#} ${Cut} {} Cut
	set Time [lindex ${LINE} 4]
		regsub -all {[\(\)]} ${Time} {} Time
set PageName([expr ${ID} / ${PageMAX}]) ${Page}
set Record(${ID}) [list ${Cut} ${Time}]
}
	}
	}
close $R
	} else {
puts "can not find \"${DataFile}\""
return
	}
}
proc Write {F} {
global Record PageMAX ID PageName
global DataFile


if ${F} then {
	if [file exists ${DataFile}] then {
catch {file rename -force ${DataFile} [file rootname ${DataFile}].bak}
	}

set W [open ${DataFile} w]}

	set Total	{0}
	set pTotal	{0}
for {set p 0} {${p} <= [expr [array size Record] / ${PageMAX}]} {incr p} {
puts "\#_______________________________p $PageName(${p})"
#puts "\#_______________________________p [format %0.3d [expr ${p}+1]]"
	for {set c 0} {${c} < ${PageMAX}} {incr c} {
set i [expr ${p} * ${PageMAX} + ${c}]
if {${i} >= [array size Record]} then {break}
if {$ID == $i} then {set Pointer \*} else {set Pointer { }}
		set IDx [format %0.3d ${i}]
		set Column [expr ${i} % ${PageMAX} + 1]
		set Cut [lindex $Record(${i}) 0]
		set Time [lindex $Record(${i}) 1]
if {${Time}=={}} then {} else {
	set pTotal [expr ${pTotal} + [TC2FR ${Time}]]
	set Total [expr ${Total} + [TC2FR ${Time}]]
}
puts "${Pointer}${IDx}\t$PageName(${p})\-${Column}\tC\#${Cut}\t\(${Time}\)\t"
if $F then {puts $W "${IDx}\t$PageName(${p})\t${Column}\tC\#${Cut}\t\(${Time}\)\t"}
	}
puts "\t\t\t\t\t[FR2TC ${pTotal}]"
if $F then {puts $W "\#\t\t\t\t\t[FR2TC ${pTotal}]"}
set pTotal {0}
}
puts "\t\t\t\tTOTAL\t[FR2TC ${Total}]"
	if $F then {
puts $W "\#\t\t\t\tTOTAL\t[FR2TC ${Total}]"
flush ${W}
close ${W}
	}
}

proc ExtraCommand {Word} {
global Record ID PageMAX PageName
global Cut Page TIME OLD_Cut OLD_Page OLD_TIME OLD_ID
global DataFile
	switch -regexp ${Word} {
{^\\.*}	{regsub {^\\} ${Word} {} x
	catch {puts [eval "$x"]}
#	catch {puts [eval "exec $x"]}
	}
{^q.*}	{exit}
{^v.*}	{Write 0}
{^a.*}	{ExtraCommand j[array size Record]}
{^i.*}	{}
{^l.*}	{}
{^b.*}	{regsub ^b ${Word} {} x
	if {${x}=={}} then {
		set ID [expr ${ID} - 1]
	} else {
		regsub -all {[^0-9]} ${x} {} x
		set ID [expr ${ID} - ${x}]
		if {${ID} < 0} then {set ID {0}}
	}
	ExtraCommand j${ID}
	}
{^j.*}	{regsub ^j ${Word} {} x
	if {${x}=={}} then {set x ${ID}}
	regsub -all {[^0-9]} ${x} {} x
	if {${x} >= [array size Record]} then {set x [expr [array size Record] -1]}
	set ID ${x}
	if {${ID} <= 0} then {
		set ID		{0}
		set Page	{1}
		set Cut		{1}
		set OLD_ID 	{0}
		set OLD_Page	{1}
		set OLD_Cut	{1}
		set OLD_TIME	{}
	} else {
		set Cut		[lindex $Record(${ID}) 0]
		set TIME	[lindex $Record(${ID}) 1]
	set OLD_ID	[expr ${ID} - 1]
		set OLD_Cut	[lindex $Record(${OLD_ID}) 0]
		set OLD_TIME	[lindex $Record(${OLD_ID}) 1]
	}
	}
{^c.+}	{regsub ^c ${Word} {} Cut
	if {[array get Record ${ID}]=={}} then {} else {
#	set Cut		[lindex $Record(${ID}) 0]
	set TIME	[lindex $Record(${ID}) 1]
set Record(${ID}) [list ${Cut} ${TIME}]
	}
	return
	}
{^p.+}	{regsub {^p} ${Word} {} PageName([expr ${ID} / ${PageMAX}])
	return
	}
{^w.*}	{
	regsub ^w ${Word} {} Arg
	if {${Arg} == {}} then {} else {set DataFile ${Arg}}

puts "${DataFile} ¸ޤ\n y\/Y 󥻥뤹ʤ n\/N\nޤϿե̾ϤƤ"
set result [GetInput "\[y\/n\/filename\]"]
switch -regexp ${result} {
{^$}	-
{^[yY]$}	{}
{^[nN]$}	{return}
default	{set DataFile ${result}}
}
	Write 1
}
{^r.*}	{
	regsub ^r ${Word} {} Arg
	if {${Arg} == {}} then {} else {set DataFile ${Arg}}

puts "${DataFile} ɤ߹ߤޤ\n y\/Y 󥻥뤹ʤn\/N\nޤϿե̾ϤƤ"
set result [GetInput "\[y\/n\/filename\]"]
switch -regexp ${result} {
{^$}	-
{^[yY]$}	{}
{^[nN]$}	{return}
default	{set DataFile ${result}}
}

	Read
	set ID [expr [array size Record] - 1]
	ExtraCommand j${ID}
}
{^h.*}	{puts "
command-help :\<ץѥ᡼\> \[άǽ\]
j\<ID\>\t\t
c\<NAME\>\t\tåֹѹ
p\<NAME\>\t\tڡ̾ѹ
b\[NUMBER\]\tԽ
v\t\tɽ
q\t\tλ
w\[FILENAME\]\t񤭽Ф
r\[FILENAME\]\tɤ߹
h\t\tإ
a\t\tɲ
\\\*\t\tޥɥ
\#\#\t
"
}
default	{return}
	}


}
##
# ()
# puts $argv ;exit
foreach RG $argv {

if [regexp {^\-.+} ${RG}] then {
	regsub {^\-} ${RG} {} RG
	switch -regexp ${RG} {
^h { usage ; exit }
^c[1-9] { regsub {^c} ${RG} {} PageMAX}
^r[1-9][0-9]* { regsub {^r} ${RG} {} RATE}
default { usage ; puts \\${RG} ; exit}
	}
} else {
# 򥿡åȤ
	if {[file exists ${RG}]} then {
		set DataFile ${RG}
		Read
	}
}
}
##
# ͥå
	set ID {0}
#	set Page	{1}
	set PageName(0)	{1}
	set Cut	{1}
	set Time	{}
	set OLD_ID {0}
	set OLD_Page	{1}
	set OLD_Cut	{1}
	set OLD_TIME	{}
# Main Loop
while {1} {
if {[array get Record ${ID}]=={}} then {

set Record(${ID}) [list ${Cut} {}]

} else {
	set Cut		[lindex $Record(${ID}) 0]
	set Time	[lindex $Record(${ID}) 1]
}
if ![expr ${ID} % ${PageMAX}] then {

	puts "\n=================P $PageName([expr ${ID} / ${PageMAX}])"
}

set KEY [GetInput "${ID}\tp$PageName([expr ${ID} / ${PageMAX}])\-[expr ${ID} % ${PageMAX} + 1]\tc\#${Cut}\t\(${Time}\)"]


switch -regexp ${KEY}	{
{^[a-z\\].*}	{ExtraCommand ${KEY} ; continue}
{^$}	{if {${OLD_TIME}=={}} then {set Cut ${OLD_Cut}}}
default	{if {${OLD_TIME}=={}} then {set Cut ${OLD_Cut}}
}
}
#֤ͤ׻
	if {${KEY}=={}} then {
set TIME ${Time}
	} else {
set TIME [RegTC ${KEY}]
	}
 puts -nonewline \b\t\t:${TIME}

# ԤΥǡOLD_DATAȤ¸()
set OLD_ID ${ID}
#set OLD_Page ${Page}
set OLD_Cut ${Cut}
set OLD_TIME ${TIME}

#set PageName([expr ${ID} / ${PageMAX} +1]) ${Page}
set Record(${ID}) [list ${Cut} ${TIME}]

incr ID
if {[expr ${ID} % ${PageMAX}]} then {
set PageName([expr ${ID} / ${PageMAX} + 1]) [IncrCut $PageName([expr ${ID} / ${PageMAX}])]
}
#set Page [expr ${ID} / ${PageMAX} + 1]
#set Page [IncrCut ${Page}]
if {${KEY}=={}} then {} else {
set Cut [IncrCut ${Cut}]}
}

