/*
	AIR用の入出力サンプル
	基本的にはnas-htmlで使用する場合nas.File オブジェクトをつくってラップするのがよさそう
	nas-File はラッピングオブジェクトとしてファイルアクセスを提供
AdobeScript/Air(Flash)/CGI上で使用するサーバーーローカルファイル/URL(読み出し専用)

ただしAirオブジェクトの操作に習熟するために今回はこのサンプルをなるべく速攻で組み込むことにする
ドキュメント上のオブジェクトを直たたきしている部分だけを調整すること

*/
if(navigator.userAgent.match(/AIR/)){

	onClosingEvent=function(event){
		if(xUI.isStored()){return}
		var msg="ファイルが保存されていません。\n保存しないで終了しますか？";
		if(!(confirm(msg))){event.preventDefault()};
		return;
	}
//終了前イベント受信
	window.nativeWindow.addEventListener(air.Event.CLOSING, onClosingEvent);
//ドラグドロップ初期化
	document.designMode="on";//.contenteditable
	document.addEventListener("dragenter", dragEnterOverHandler);
	document.addEventListener("dragover", dragEnterOverHandler);
	document.addEventListener("drop", dropHandler);

  function dragEnterOverHandler(event){
	event.preventDefault(); 
	return;
	var myFiles=event.dataTransfer.getData("application/x-vnd.adobe.air.file-list");
	if((myFiles)&&(myFiles[0].nativePath.match(/\.(xps|tsh|ard|ardj|csv)$/i))){
		event.dataTransfer.effectAllowed = "copy"; 
	}else{
		event.dataTransfer.effectAllowed = "none";
	}
	}

   function dropHandler(event){
//ファイルを総当たりで最初にあたった読み込み可能なファイルを読み込んで終了
/*
	将来的には多種のドラッグドロップを受け入れるので注意
*/

	var myFiles=event.dataTransfer.getData("application/x-vnd.adobe.air.file-list");
for(var idx=myFiles.length-1;idx>=0;idx--){
	if(myFiles[idx].nativePath.match(/\.(xps|tsh|ard|ardj|csv)$/i)){
		fileBox.fileQueue=myFiles[idx];//現在キュー数は1のみ
		var myAction=xUI.checkStored("saveAndOpenDropFile");
		if(myAction){
			fileBox.currentFile=myFiles[idx];
			fileBox.readIN();
		}
		break;
	}
}
return;
//この下はサンプルコード
/*

switch(event.dataTransfer.types.toString())
{
case "text/plain":
	alert(event.dataTransfer.getData("text/plain"));
break;
case "application/x-vnd.adobe.air.file-list":
	alert(event.dataTransfer.getData("application/x-vnd.adobe.air.file-list")[0])
	
break;
default:

}
return;

	for(var prop in event){ 
	   air.trace(prop + " = " + event[prop]); 
	} 



	var row = document.createElement('tr'); 
	row.innerHTML = "<td>" + event.dataTransfer.getData("text/plain") + "</td>" + 
		"<td>" + event.dataTransfer.getData("text/html") + "</td>" + 
		"<td>" + event.dataTransfer.getData("text/uri-list") + "</td>" + 
		"<td>" + event.dataTransfer.getData("application/x-vnd.adobe.air.file-list") + 
		"</td>"; 
 
	var imageCell = document.createElement('td'); 
	if((event.dataTransfer.types.toString()).search("image/x-vnd.adobe.air.bitmap") > -1){ 
		imageCell.appendChild(event.dataTransfer.getData("image/x-vnd.adobe.air.bitmap")); 
	} 
	row.appendChild(imageCell); 
	var parent = emptyRow.parentNode; 
	parent.insertBefore(row, emptyRow); 
*/
	} 

/*	ファイルハンドリングオブジェクト
	CGIサービスの設計時は同名オブジェクトに同名メソッドを作成して対処するので要注意
 */
//ラップオブジェクト
	var fileBox=new Object();

		fileBox.currentFile=null; // The current file in the editor.
		fileBox.stream=null; // A FileStream object, used to read and write files.
		fileBox.defaultDir=null; // The default directory location.
		fileBox.chooserMode=null; // Whether the FileChooser.html window is used as an Open or Save As window.
		fileBox.fileQueue=null;
		fileBox.openMode=null;//ファイルモード　saveAndOpen/saveAndOpenDropFile/saveAndOpenArgFile or ""
		fileBox.recentDocuments=new Array();//recentDocumentsStack
		fileBox.contentText="";//テキストバッファ
			/**
			 * UI初期化
			 */
			fileBox.init=function() {
				fileBox.defaultDir = air.File.documentsDirectory;
			}
/**
 *recentDocumentにファイルを加えるメソッド　同じファイルがあったら追加しない
 */
	fileBox.recentDocuments.add=function(myFile){
//if(dbg){dbgPut("add file :"+this.length +" : "+ this.toString());}
		for(var file=0;file<this.length;file++){
//		dbgPut(myFile.name +" : " +this[file].name)
			if(myFile==this[file]){return true}
		}
		this.push(new air.File(myFile.url));//参照をpushすると次に比較できなくなるので新しいオブジェクトでpush
		return true;
	}
			/**
			 * Displays the FileChooser.html file in a new window, and sets its mode to "Open".
			 */
			fileBox.openFileDB=function() {
			var myAction=xUI.checkStored("saveAndOpen");


				var fileChooser;
				if(fileBox.currentFile)
				{
					fileChooser = fileBox.currentFile;
				}
				else
				{
					fileChooser = fileBox.defaultDir;
				}
				var txtFilter = new air.FileFilter("TimeSheetFile(*.xps *.tsh *.ard *.ardj *.csv *.txt)", "*.xps;*.tsh;*.ard;*.ardj;*.csv;*.txt");
				fileChooser.browseForOpen("Open",[txtFilter]);
				fileChooser.addEventListener(air.Event.SELECT, fileBox.openFile);
			}

			/**
			 * Opens and reads a file.
			 */
			fileBox.openFile = function (event) {
				fileBox.currentFile = event.target;//ファイル設定
				fileBox.readIN();
				event.target.removeEventListener(air.Event.SELECT, fileBox.openFile); 
				fileBox.recentDocuments.add(fileBox.currentFile);//最近のファイルに追加
				sync();//タイトル同期
			}
			/**
			 * readContent カレントファイルを読み込み内容を返す
			 */
			fileBox.readContent = function(){
				this.stream = new air.FileStream();
				try
				{
					fileBox.contentText="";//データバッファテキストクリア
					var tmpBuff="";//一時バッファ確保
					this.stream.open(fileBox.currentFile, air.FileMode.READ);//ファイルストリーム開く(同期)
				  if(fileBox.currentFile.extension.match(/(xps|te?xt|ardj)/)){
					var str = this.stream.readUTFBytes(this.stream.bytesAvailable);//UTFテキストとして読み込み
				  }else{
					var str = this.stream.readMultiByte(this.stream.bytesAvailable,"shift_jis");//s-JISテキストとして読み込み
				  }
					this.stream.close();
					fileBox.contentText=str;//内容をセット
					return fileBox.contentText;
				}
				catch(error)
				{
					ioErrorHandler();
				}
			}

			/**
			 * readIN textSource to XPS buffer
			 */
			fileBox.readIN = function(){
				this.stream = new air.FileStream();
				try
				{
					fileBox.contentText="";//データバッファテキストクリア
					var tmpBuff="";//一時バッファ確保
					this.stream.open(fileBox.currentFile, air.FileMode.READ);//ファイルストリーム開く(同期)
				  if(fileBox.currentFile.extension.match(/(xps|te?xt|ardj)/)){
					var str = this.stream.readUTFBytes(this.stream.bytesAvailable);//UTFテキストとして読み込み
				  }else{
					var str = this.stream.readMultiByte(this.stream.bytesAvailable,"shift_jis");//s-JISテキストとして読み込み
				  }
					this.stream.close();
					fileBox.contentText=str;//内容をセット

//アプリケーション初期化前にはXPSオブジェクトはあるが実質初期化前なので、
//xUI初期化のタイミングだけ認識してそれ以前なら以下のルーチンは実行しない
//開始時点でxUI空オブジェクトで初期化されるのでxUI.initを判定
			if(xUI.init){
				var myResult= XPS.readIN(fileBox.contentText);
			}else{
				var myResult=false;
			}

//取得したストリームを検査する 空ストリームXPS以外のストリームなら破棄してエラーコードを返す
//alert("open:"+myResult)
//document.getElementById("mainText").value = str;//メインバッファにストリームを流し込む
//document.title = "Text Editor - " + currentFile.name;//ドキュメントラベル更新
					if(myResult){xUI.init(XPS);nas_Rmp_Init();}
					// ここで取得したストリームをそのまま返す
					document.title=fileBox.currentFile.name;//ちょと注意　一括変更部分が必要
					return myResult;
				}
				catch(error)
				{
					ioErrorHandler();
				}
			}
			/**
			 * Displays the "Save As" dialog box.
			 * オープン時に未保存だった場合、保存後にオープンコマンドを実行するモードを作成
			 */
			fileBox.saveAs=function () {
				var fileChooser;//
				if(fileBox.currentFile)
				{
					fileChooser = fileBox.currentFile;
				}
				else
				{
					var fName=encodeURI(XPS.scene.toString()+XPS.cut.toString()+'\.xps')
					fileChooser = new air.File(fileBox.defaultDir.url+"/"+fName)
				}

				fileChooser.browseForSave("SaveAs");

				fileChooser.addEventListener(air.Event.SELECT, fileBox.saveAsSelectHandler);

			}	
			fileBox.saveAsSelectHandler=function (event) {
				fileBox.currentFile = event.target;
				event.target.removeEventListener(air.Event.SELECT, fileBox.saveAsSelectHandler);
				xUI.setStored("force");//ファイルを切り換えたので強制保存セット
				sync();
				fileBox.saveFile();
			}

			/**
			 * Opens and saves a file with the data in the mainText textArea element. 
			 * Newline (\n) characters in the text are replaced with the 
			 * platform-specific line ending character (File.lineEnding), which is the 
			 * line-feed character on Mac OS and the carriage return character followed by the 
			 * line-feed character on Windows.
			 */
			fileBox.saveFile=function () {
				if (fileBox.currentFile == null) 
				{
					fileBox.saveAs();
				} else {
				if(xUI.isStored()){
					if(! confirm("ファイルは保存済みだと思います。上書き保存しますか")){return}}
					try 
					{
						this.stream = new air.FileStream();
						this.stream.open(fileBox.currentFile, air.FileMode.WRITE);

						var outData = XPS.toString();
//						outData = outData.replace(/\n/g, air.File.lineEnding);
						this.stream.writeUTFBytes(outData);
						this.stream.close();
						fileBox.recentDocuments.add(fileBox.currentFile);//最近のファイルに追加

//						document.title = "Text Editor - " + currentFile.name;
						xUI.setStored("current");//ファイル保存を行ったのでリセットする;
						sync();//タイトル同期
						switch(fileBox.openMode){
						case "saveAndOpen":
							fileBox.openFileDB();
//ここでopenFileDB()がマルチスレッドで実行される
							fileBox.openMode=null;
						break;
						case "saveAndOpenDropFile":
						case "saveAndOpenArgFile":
							fileBox.currentFile=new air.File(fileBox.fileQueue.url);
							fileBox.readIN();
							fileBox.openMode=null;fileBox.fileQueue=null;
						break;
						}
						//モードに従ってオープン
					} 
					catch(error) 
					{
						ioErrorHandler();
					}
				}
			}


fileBox.storeOtherExtensionFile=function(content,extsn){
	if(! content){return false};
	fileBox.contentText=content;
	if(! extsn){extsn="txt"};
	var fName=encodeURI(XPS.scene.toString()+XPS.cut.toString()+'.'+extsn);
	var fileChooser = new air.File(fileBox.defaultDir.url+"/"+fName);
	fileChooser.browseForSave("SaveDataAs "+extsn);
	fileChooser.addEventListener(air.Event.SELECT, fileBox.saveAsExtsnSelectHandler);
}

	fileBox.saveAsExtsnSelectHandler=function (event) {
		var myFile = event.target;
		event.target.removeEventListener(air.Event.SELECT, fileBox.saveAsExtsnSelectHandler);
	try 
	{
		this.stream = new air.FileStream();
		this.stream.open(myFile, air.FileMode.WRITE);
		var outData = fileBox.contentText;
//		outData = outData.replace(/\n/g, air.File.lineEnding);
		this.stream.writeUTFBytes(outData);
		this.stream.close();
	} catch(error) {
		ioErrorHandler();
	}

	}
			/**
			 * Error message for file I/O errors. 
			 */
			function ioErrorHandler() {
				alert("Error reading or writing the file.");
			}
/*
アプリケーションがINVOKEイベントの処理が出来るようにする
*/
//		NativeApplication.nativeApplication.addEventListener(InvokeEvent.INVOKE, onInvokeEvent); 
		air.NativeApplication.nativeApplication.addEventListener(air.InvokeEvent.INVOKE, onInvokeEvent);

		var systemArguments;//システム引数を格納するオブジェクト
		var currentDir;

/*	イベントコール時に処理される関数	*/
		function onInvokeEvent(invocation) {
				var arguments = invocation.arguments; 
	 			var currentDir = invocation.currentDirectory;
	if(arguments.length){
if(dbg){dbgPut(arguments.length + " : arguments")};
		for (var idx=arguments.length-1;idx>=0;idx--)
		{
if(dbg){dbgPut(idx+" : "+arguments[idx])};
			var myFilePath=arguments[idx];

			if(myFilePath.match(/\.(xps|tsh|ard|ardj|csv)$/i)){
if(dbg){dbgPut("can read file "+ myFilePath)};
if(true){
			var myFile=new air.File();//新規ファイル作成
			myFile.nativePath=myFilePath;//ローカルパスでオブジェクト指定
				if((myFile.exists)&&(fileBox.currentFile!==myFile)){
					fileBox.fileQueue=myFile;//現在キュー数は1のみ

//xUIは空オブジェクトで初期化される。再初期化が済んでいたらセーブチェックが必要だがそれ以外は無条件で新ファイル読込み
//チェック後にキャンセルリザルトがあった場合は処理自体をスキップしたいが現状は
					if(xUI.init){
					//初期化済
if(xUI.isStored()){
//ファイルは保存済なのでキューをカレントに移行してファイルを読み込む
							fileBox.fileQueue=null;
							fileBox.currentFile=myFile;
							fileBox.readIN();

}else{
//ファイルが保存されていないのでダイアログをだして分岐動作

var msg="現在のファイルが保存されていません。\n現在のファイルを保存してファイルを読み込みますか?\n yes/保存して読込み no/保存しないで読込み cancel/読込みcancel"
var myAction=function(){
	switch(this.status){
	case 0:;//保存を行ってから読み込む
//		if(xUI.init){xUI.setStored("force")};//強制的に保存が行われるようセット
		fileBox.openMode="saveAndOpenArgFile";//モードセット
		fileBox.saveFile();//保存する強制モードで無いのでこのコールでブレークして戻る
	break;
	case 1:;//保存しないで読込み
		fileBox.currentFile=new air.File(fileBox.fileQueue.url);//参照を実体化
		fileBox.readIN();
		fileBox.fileQueue=null;
	break;	
	default:;//cancel キューを破棄して動作停止
		fileBox.fileQueue=null;
	}
}
nas.showModalDialog("confirm2",msg,"","",myAction);

}
					}else{
					//初期化前(起動時のみ)
						fileBox.currentFile=myFile;
						fileBox.readIN();
					}
						break;
				}
}
			}
		}
if(dbg){dbgPut(arguments.length + " : arguments")};
	}
		}
/* ****************************************************************************
ネイティブメニューを作成
メニューを作ることでHTMLモードでのメニューを隠せるので画面を広く使える

 **************************************************************************** */
var application = air.NativeApplication.nativeApplication; 

function setMenu(){ 
	var fileMenu;
	var editMenu;
	var referenceMenu;
	var documentMenu;
	var mapMenu;
	var toolMenu;
// win
	if ( air.NativeWindow.supportsMenu &&
	 nativeWindow.systemChrome != air.NativeWindowSystemChrome.NONE) { 
	nativeWindow.menu = new air.NativeMenu(); 
	nativeWindow.menu.addEventListener(air.Event.SELECT, selectCommandMenu); 

	fileMenu = nativeWindow.menu.addItem(new air.NativeMenuItem("File")); 
	fileMenu.submenu = createFileMenu(); 
	 
	editMenu = nativeWindow.menu.addItem(new air.NativeMenuItem("Edit")); 
	editMenu.submenu = createEditMenu(); 

	refMenu = nativeWindow.menu.addItem(new air.NativeMenuItem("Reference")); 
	refMenu.submenu = createRefMenu(); 

	xpsMenu = nativeWindow.menu.addItem(new air.NativeMenuItem("Xps")); 
	xpsMenu.submenu = createXpsMenu(); 

	mapMenu = nativeWindow.menu.addItem(new air.NativeMenuItem("Map")); 
	mapMenu.submenu = createMapMenu(); 

	toolMenu = nativeWindow.menu.addItem(new air.NativeMenuItem("Tools")); 
	toolMenu.submenu = createToolMenu(); 
	} 
// mac
	if (air.NativeApplication.supportsMenu) {
	application.menu.addEventListener(air.Event.SELECT, selectCommandMenu);
//元から存在するメニューを削除　または名前を変更して使ってもよい…
if(false){
application.menu.removeItemAt(1);
application.menu.removeItemAt(2);
application.menu.removeItemAt(3);
}
//	fileMenu = application.menu.addItem(new air.NativeMenuItem("ファイル"));
fileMenu = application.menu.items[1];
	fileMenu.submenu = createFileMenu();
//	editMenu = application.menu.addItem(new air.NativeMenuItem("編集")); 
editMenu = application.menu.items[2]; 
	editMenu.submenu = createEditMenu();
	xpsMenu = application.menu.addItem(new air.NativeMenuItem("Xps")); 
	xpsMenu.submenu = createXpsMenu(); 
	mapMenu = application.menu.addItem(new air.NativeMenuItem("Map")); 
	mapMenu.submenu = createMapMenu(); 
	toolMenu = application.menu.addItem(new air.NativeMenuItem("Tools")); 
	toolMenu.submenu = createToolMenu(); 
	} 
} 
	 
function createFileMenu() { 
	var fileMenu = new air.NativeMenu();
	fileMenu.addEventListener(air.Event.SELECT,selectCommandMenu);

	var newCommand = fileMenu.addItem(new air.NativeMenuItem("New"));
		newCommand.addEventListener(air.Event.SELECT, selectCommand);
		newCommand.keyEquivalent = "n";
	var openCommand = fileMenu.addItem(new air.NativeMenuItem("Open"));
		openCommand.addEventListener(air.Event.SELECT, selectCommand);
		openCommand.keyEquivalent = "o";
	var saveCommand = fileMenu.addItem(new air.NativeMenuItem("Save"));
		saveCommand.addEventListener(air.Event.SELECT, selectCommand);
		saveCommand.keyEquivalent = "s";
	var saveasCommand = fileMenu.addItem(new air.NativeMenuItem("SaveAs"));
		saveasCommand.addEventListener(air.Event.SELECT, selectCommand);
		saveasCommand.keyEquivalent = "S";
	var restoreCommand = fileMenu.addItem(new air.NativeMenuItem("Restore"));
		restoreCommand.addEventListener(air.Event.SELECT, selectCommand);
		restoreCommand.keyEquivalent = "R";
	var quitCommand = fileMenu.addItem(new air.NativeMenuItem("Quit"));
		quitCommand.addEventListener(air.Event.SELECT, selectCommand);
		quitCommand.keyEquivalent = "q";

	var openFile = fileMenu.addItem(new air.NativeMenuItem("Open Recent"));
	openFile.submenu = new air.NativeMenu(); 
	openFile.submenu.addEventListener(air.Event.DISPLAYING, updateRecentDocumentMenu); 
	openFile.submenu.addEventListener(air.Event.SELECT, selectCommandMenu); 

	return fileMenu; 
} 

function createEditMenu() { 
	var editMenu = new air.NativeMenu(); 
	editMenu.addEventListener(air.Event.SELECT,selectCommandMenu); 

	var selectAll = editMenu.addItem(new air.NativeMenuItem("selectAll"));
		selectAll.addEventListener(air.Event.SELECT,selectCommand);
		selectAll.keyEquivalent = "a";
	var copyCommand = editMenu.addItem(new air.NativeMenuItem("Copy"));
		copyCommand.addEventListener(air.Event.SELECT,selectCommand);
		copyCommand.keyEquivalent = "c";
	var cutCommand = editMenu.addItem(new air.NativeMenuItem("cut"));
		cutCommand.addEventListener(air.Event.SELECT,selectCommand);
		cutCommand.keyEquivalent = "x";
	var pasteCommand = editMenu.addItem(new air.NativeMenuItem("Paste")); 
		pasteCommand.addEventListener(air.Event.SELECT, selectCommand); 
		pasteCommand.keyEquivalent = "v"; 

	editMenu.addItem(new air.NativeMenuItem("", true));//セパレータ

	var preferencesCommand = editMenu.addItem(new air.NativeMenuItem("Preferences")); 
	preferencesCommand.addEventListener(air.Event.SELECT,selectCommand); 
	 
	return editMenu; 
} 

function createRefMenu() { 
	var referenceMenu = new air.NativeMenu(); 
	referenceMenu.addEventListener(air.Event.SELECT,selectCommandMenu);

	var imRCommand = referenceMenu.addItem(new air.NativeMenuItem("importReference"));
	imRCommand.addEventListener(air.Event.SELECT,selectCommand);
	imRCommand.keyEquivalent = "i";
	var dtRCommand = referenceMenu.addItem(new air.NativeMenuItem("copyToRef"));
	dtRCommand.addEventListener(air.Event.SELECT,selectCommand);
	dtRCommand.keyEquivalent = "<";
	var dtECommand = referenceMenu.addItem(new air.NativeMenuItem("copyFromRef"));
	dtECommand.addEventListener(air.Event.SELECT,selectCommand);
	dtECommand.keyEquivalent = ">";
	var clRCommand = referenceMenu.addItem(new air.NativeMenuItem("clearReference"));
	clRCommand.addEventListener(air.Event.SELECT,selectCommand);
	clRCommand.keyEquivalent = "C";

	return referenceMenu; 
}

function createXpsMenu() { 
	var xpsMenu = new air.NativeMenu(); 
	xpsMenu.addEventListener(air.Event.SELECT,selectCommandMenu);

	var rwCommand = xpsMenu.addItem(new air.NativeMenuItem("dataPanel"));
	rwCommand.addEventListener(air.Event.SELECT,selectCommand);
	rwCommand.keyEquivalent = "W";
	var dcCommand = xpsMenu.addItem(new air.NativeMenuItem("Document"));
	dcCommand.addEventListener(air.Event.SELECT,selectCommand);
	dcCommand.keyEquivalent = "D";
	var prtCommand = xpsMenu.addItem(new air.NativeMenuItem("saveAsHTML"));
	prtCommand.addEventListener(air.Event.SELECT,selectCommand);
	prtCommand.keyEquivalent = "D";

	return xpsMenu; 
}

function createMapMenu() { 
	var mapMenu = new air.NativeMenu(); 
	mapMenu.addEventListener(air.Event.SELECT,selectCommandMenu);

	var Command = mapMenu.addItem(new air.NativeMenuItem("cmd"));
	Command.addEventListener(air.Event.SELECT,selectCommand);
	Command.keyEquivalent = "M";

	return mapMenu; 
}

function createToolMenu() { 
	var toolMenu = new air.NativeMenu(); 
	toolMenu.addEventListener(air.Event.SELECT,selectCommandMenu);

	var dmbCommand = toolMenu.addItem(new air.NativeMenuItem("dropdownMenuBar"));
	dmbCommand.addEventListener(air.Event.SELECT,selectCommand);
	dmbCommand.keyEquivalent = "m";
	var utCommand = toolMenu.addItem(new air.NativeMenuItem("commandBar"));
	utCommand.addEventListener(air.Event.SELECT,selectCommand);
	utCommand.keyEquivalent = "B";
	var skbCommand = toolMenu.addItem(new air.NativeMenuItem("softwareKB"));
	skbCommand.addEventListener(air.Event.SELECT,selectCommand);
	skbCommand.keyEquivalent = "K";
	var abtCommand = toolMenu.addItem(new air.NativeMenuItem("about"));
	abtCommand.addEventListener(air.Event.SELECT,selectCommand);
	abtCommand.keyEquivalent = "A";

	return toolMenu; 
}



function updateRecentDocumentMenu(event) { 
	air.trace("Updating recent document menu."); 
	var docMenu = air.NativeMenu(event.target); 
	 
	for (var i = docMenu.numItems - 1; i >= 0; i--) { 
	docMenu.removeItemAt(i); 
	} 
	 
	for (var file=0;file<fileBox.recentDocuments.length;file++) { 
	var menuItem =  
		docMenu.addItem(new air.NativeMenuItem(fileBox.recentDocuments[file].name)); 
	menuItem.data = fileBox.recentDocuments[file]; 
	menuItem.addEventListener(air.Event.SELECT, selectRecentDocument); 
	} 
} 
 
function selectRecentDocument(event) {
	if(dbg){dbgPut("Selected recent document: " + event.target.data.name)};
	//open
	fileBox.currentFile=new air.File(event.target.data.url);
	fileBox.readIN();
}

function selectCommand(event) {
	switch (event.target.label)
	{
	case "SaveAs":fileBox.saveAs();
	break;
	case "Save":fileBox.saveFile();
	break;
	case "Open":fileBox.openFileDB();
	break;
	case "Restore":if((! xUI.isStored())&&(confirm("現在の編集を破棄しますか？"))){fileBox.readIN()};//現在の編集を破棄して強制的に読み込み
	break;
	case "New":myScenePref.open();document.getElementById("scnNewSheet").checked=true;
	break;
	case "Copy":chkValue("copy");
	break;
	case "selectAll":chkValue("selall");;
	break;
	case "cut":chkValue("cut");;
	break;
	case "Paste":chkValue("paste");;
	break;
	case "undo":chkValue("undo");;
	break;
	case "redo":chkValue("redo");;
	break;
	case "Preferences":var myPref=new Pref();myPref.open();
	break;
	case "Document":myScenePref.open();
	break;
	case "importReference":;
	break;
	case "copyToRef":putReference();
	break;
	case "copyFromRef":getReference();
	break;
	case "clearReference":xUI.referenceXPS=new Xps(XPS.layers.length,XPS.duration());nas_Rmp_Init();
	break;
	case "dataPanel":sWitchPanel("Data");
	break;
	case "saveAsHTML":fileBox.storeOtherExtensionFile(printHTML(true),"html");
	break;
	case "Quit":window.close();
	break;
	case "dropdownMenuBar":if($("#pMenu").is(":visible")){$("#pMenu").hide()}else{$("#pMenu").show()};
	break;
	case "commandBar":sWitchPanel("Utl");
	break;
	case "softwareKB":sWitchPanel("Tbx");
	break;
	case "about":sWitchPanel("Ver");
	break;
/*
	case "":;
	break;
*/
	default:
		if(dbg){dbgPut("Selected command: " + event.target.label)}; 
	}

}
 
function selectCommandMenu(event) { 
	if (event.currentTarget.parent != null) { 
	var menuItem = findItemForMenu(event.currentTarget); 
	if(menuItem != null){ 
		air.trace("Select event for \"" + event.target.label +  
		"\" command handled by menu: " + menuItem.label); 
	} 
	} else { 
	air.trace("Select event for \"" + event.target.label +  
		"\" command handled by root menu."); 
	} 
} 
 
function findItemForMenu(menu){ 
	for (var item in menu.parent.items) { 
	if (item != null) { 
		if (item.submenu == menu) { 
		return item; 
		} 
	} 
	} 
	return null; 
} 


/*初期化*/
fileBox.init();

//setupNativeMenu();
setMenu();
//fileBox.openFileDB();
//if(fileBox.contentText){alert(fileBox.contentText)}


/*	システムクリップボードに書き出す
引数はテキストのみで

*/
//var testCLipboard=new Clipboard();

function writeClipBoard(myContent){
	if(! myContent){return false}
	myContent=myContent.replace(/(\r)?\n/g,"\r\n");//for Win
	air.Clipboard.generalClipboard.clear(); //clear Clipboard
	air.Clipboard.generalClipboard.setData(air.ClipboardFormats.TEXT_FORMAT, myContent, false);//write Data
}

	function getClipBoard()
	{
		var myResult=false;
		if(air.Clipboard.generalClipboard.hasFormat(air.ClipboardFormats.TEXT_FORMAT)){ 
			myResult = air.Clipboard.generalClipboard.getData(air.ClipboardFormats.TEXT_FORMAT);
		}
		return myResult;
	}
}else{
/*	AIR以外の環境でのダミーオブジェクト
サーバを作成した時にはサーバとの連絡に使用する
 */
	var fileBox=new Object();

		fileBox.currentFile=null; // The current file in the editor.
		fileBox.stream=null; // A FileStream object, used to read and write files.
		fileBox.defaultDir=null; // The default directory location.
		fileBox.chooserMode=null; // Whether the FileChooser.html window is used as an Open or Save As window.
		
		fileBox.contentText="";//テキストバッファ
}
