//	読み込みメソッドのXpsパーサ
/*
	元の読み込みメソッドは、このパーサのラッパとして残置
	他フォーマットのデータパーサはライブラリに分離される。
	このメソッドはXpsのパース専用になる
	(将来の拡張用として必須)2013.04.06
	ステージ拡張用にソース分離編集開始
memo
ステージは入れ子構造が無いことを前提に配置される（ステージ記述は、前ステージを閉じる）
第一パスでソースをステージごとに分離する。

初期ステージとして、新たなXpsオブジェクトをパースする。（タイムライン数や継続時間等に標準値を持ったデフォルトオブジェクト）
これは、初期編集対象。

得られたXpsをプロトタイプとして次のステージを作成して、ソースをパースしてゆく
順次積み重ねて、最終のオブジェクトをリザルトとして返す。（副次ステージのオブジェクトとなる）

データテーブルの無いソースに対してテーブルを作らない方向でパースしないとダメなんだけど
初期ステージでは不可？
なんかノウハウ無いので困る
*/
Xps.prototype.parseXps=function(datastream)
{
	if(! datastream.match){return false};
//ラインで分割して配列に取り込み
	var SrcData=new Array();
	if(datastream.match(/\r/)){datastream=datastream.replace(/\r\n?/g,("\n"))};
	SrcData=datastream.split("\n");
//		var AEK=true;//AEKey read-formatTestFlag
//データストリーム判別プロパティ
	SrcData.startLine	=0;//データ開始行
//	SrcData.dataClass	="";//データバージョン識別用に流用？
//データ種別判定は、削除　作業開始2013.04.04
//ソースデータのプロパティ
	SrcData.layerHeader	=0;//レイヤヘッダ開始行
	SrcData.layerProps	=0;//レイヤプロパティエントリ数
	SrcData.layerCount	=0;//レイヤ数
	SrcData.layers= new Array();//レイヤ情報トレーラー
	SrcData.layerBodyEnd	=0;//レイヤ情報終了行
	SrcData.frameCount	=0;//読み取りフレーム数
//第一パス
//データ冒頭の空白行を無視して、データ開始行を取得
//識別行の確認
//冒頭ラインが識別コードまたは空行でなかった場合は、さようなら御免ね
//IEのデータの検証もここでやっといたほうが良い?
	for (l=0;l<SrcData.length;l++)
	{
		if(SrcData[l].match(/^\s*$/))
		{
			continue;
		}else{

		if(MSIE){
	var choped=SrcData[l].charCodeAt(SrcData[l].length-1);
	if(choped<=32)
	SrcData[l] = SrcData[l].slice(0,-1);
		}
		//なぜだかナゾなぜに一文字多いのか?

/*
	データ処理中に含まれていた他フォーマットの解析部分は、
	別ライブラリで吸収するのでこのソースからは削除
	TSX AEK 部分は未処理　2013.0405
	どうしましょったら、どーしましょ まだ思案中 シアンは赤の補色です。
*/
if(SrcData[l].match(/^nasTIME-SHEET\ 0\.[1-4]$/))
{
	SrcData.startLine =l;//データ開始行
	break;
}else{
	this.errorMsg[10]=SrcData[l];//message10に当該トークンを格納
	this.errorCode=2;return false;
//	"002:どうもすみません。このデータは読めないみたいダ\n"
}
		}
	};
//第一パスおしまい。なんにもデータが無かったらサヨナラ
//"読み取るデータがないのです。";
	if(SrcData.startLine==0 && SrcData.length==l){ this.errorCode=3;return false;}
/*
	if(! SrcData.dataClass){
		this.errorMsg[10]=("009:想定外エラー\n"+SrcData.dataClass + "error!");
		this.errorCode=9;return false;
	}
*/	
//##変数名とプロパティ名の対照テーブル//
	var varNames=[
"MAPPING_FILE",
"TITLE",
"SUB_TITLE",
"OPUS",
"SCENE",
"CUT",
"TIME",
"TRIN",
"TROUT",
"FRAME_RATE",
"CREATE_USER",
"UPDATE_USER",
"CREATE_TIME",
"UPDATE_TIME"
	];
	var propNames=[
"mapfile",
"title",
"subtitle",
"opus",
"scene",
"cut",
"time",
"trin",
"trout",
"framerate",
"create_user",
"update_user",
"create_time",
"update_time"
	];
	var props =new Array(varNames.length);
for (i=0;i<varNames.length;i++){props[varNames[i]]=propNames[i];};
//	データ走査第二パス
//		時間プロパティ欠落時のために初期値設定
//		SrcData.time="6+0";
		SrcData.trin=[0,"trin"];
		SrcData.trout=[0,"trout"];

	for(line=SrcData.startLine;line<SrcData.length;line++){
			//前置部分を読み込みつつ、本体情報の確認
		if(MSIE){
	var choped=SrcData[line].charCodeAt(SrcData[line].length-1);
	if(choped<=32)
	SrcData[line] = SrcData[line].slice(0,-1);
		}
		//なぜだかナゾなぜに一文字多いのか?
//			シートプロパティにマッチ
		if(SrcData[line].match(/^\#\#([A-Z].*)=(.*)$/))
		{
			nAme=RegExp.$1;vAlue=RegExp.$2;
//	時間関連プロパティを先行して評価。
//	読み取ったフレーム数と指定時間の長いほうでシートを初期化する。
switch (nAme)
{
case	"TRIN":			;//トランシットイン
case	"TROUT":		;//トランシットアウト
		var tm=nas.FCT2Frm(vAlue.split(",")[0]);
		if(isNaN(tm)){tm=0};
		var nm=vAlue.split(",")[1];
		if(! nm){nm=props[nAme]};
			  SrcData[props[nAme]]=[tm,nm];
			break	;
case	"TIME":			;//カット尺
		var tm=nas.FCT2Frm(vAlue);
		if(isNaN(tm)){tm=0}
			  SrcData[props[nAme]]=tm;

			break	;
default:				;//時間関連以外
			SrcData[props[nAme]]=vAlue;
//					判定した値をプロパティで控える
}
		}
//			レイヤヘッダまたは終了識別にマッチ
		if(SrcData[line].match(/^\[(([a-zA-Z]+)\t?.*)\]$/))
		{
//シート終わっていたらメモを取り込んで終了
			if(SrcData[line].match(/\[END\]/))
			{
//	シートボディ終了ライン控え
				SrcData.layerBodyEnd=line;
				SrcData["memo"]='';
				for(li=line+1;li<SrcData.length;li++)
				{
					SrcData["memo"]+=SrcData[li];
					if((li+1) < SrcData.length){SrcData["memo"]+="\n"};//最終行以外は改行を追加
				}

					break ;
			}else{
//各レイヤの情報を取得
//	レイヤヘッダの開始行を記録
				if(SrcData.layerHeader==0)
					{SrcData.layerHeader=line};
//	ロットを記録(最大の行を採る)
				var LayerCount =
				SrcData[line].split("\t").length-3;
				SrcData.layerCount=
				(SrcData.layerCount<LayerCount)?
				LayerCount	:	SrcData.layerCount;
//	エントリ数を記録
				SrcData.layerProps++;
			}
		}else{
//	シートデータ本体の行数を加算
	if(! SrcData[line].match(/^\#.*$/))
	{
		SrcData.frameCount++;	//読み取りフレーム数
	}
		}
	}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
//	第二パス終了・読み取った情報でXPSオブジェクトを再初期化(共通)
	SrcData.duration=
	Math.ceil(SrcData.time+(SrcData.trin[0]+SrcData.trout[0])/2);
//		トランシット時間の処理は要再考。現状は切り上げ
	var SheetDuration=(SrcData.duration>(SrcData.frameCount-1))?
	SrcData.duration : (SrcData.frameCount-1)	;//大きいほう

//	///////////////////////
//	if(dbg) dbgPut("count/duration:"+SrcData.layerCount+":"+SheetDuration);

	this.init(SrcData.layerCount,SheetDuration);//再初期化

//	第二パスで読み取ったプロパティをXPSに転記
//					タイム以外はそのまま転記
	for(id=0;id<propNames.length;id++)
	{
		prpName=propNames[id];
		if(SrcData[prpName] && prpName!="time"){this[prpName]=SrcData[prpName];}
	}

//	読み取りデータを調べて得たキーメソッドとブランク位置を転記
for (var lyr=0;lyr<SrcData.layers.length;lyr++)
{
  this.layers[lyr].blmtd	=SrcData.layers[lyr].blmtd;
  this.layers[lyr].blpos	=SrcData.layers[lyr].blpos;
  this.layers[lyr].lot	=SrcData.layers[lyr].lot;
}

	if(SrcData["memo"]) this["memo"]=SrcData["memo"];//memoがあれば転記


// ///// 各エントリのレイヤプロパティとシート本体情報を取得(第三パス)

		var frame_id=0;//読み取りフレーム初期化

	for(line=SrcData.layerHeader;line<SrcData.layerBodyEnd;line++)
	{
//角括弧で開始するデータはレイヤプロパティ
		if(SrcData[line].match(/^\[(([a-zA-Z]+)\t.*)\]$/))
		{
				var layerProps= RegExp.$1.split("\t");
				var layerPropName=RegExp.$2;
					if(layerPropName=="CELL"){layerPropName="name"};
//	これ(CELL)だけシート表記とプロパティ名が一致していないので置換 一致が少ない場合はテーブルが必要になる
				for (c=0;c<SrcData.layerCount;c++)
				{	this["layers"][c][layerPropName]=layerProps[c+2]	}
		}else{
//ほかコメント以外はすべてシートデータ
			if(!SrcData[line].match(/^\#.*$/))
			{
				myLineAry=(SrcData[line].match(/\t/))? SrcData[line].split("\t"):SrcData[line].replace(/[\;\:\,]/g,"\t").split("\t");
				for (col=1;col<=(SrcData.layerCount+2);col++)
				{
//シート本体データの取得
					this.xpsBody[col-1][frame_id]=
					(myLineAry[col]!=undefined)?
					myLineAry[col].replace(/(^\s*|\s*$)/,""):"";
				}
				frame_id++;
			}
		}
	}


// ///// 読み取ったデータを検査する(データ検査は別のメソッドにしろ!??)
/*
//	マップファイルは、現在サポート無し
//		サポート開始時期未定
//この情報は、他の情報以前に判定して、マップオブジェクトの生成が必要。
//マップ未設定状態では、代用マップを作成して使用。
//代用マップは、デフォルトで存在。
<<
	現在は、代用MAPオブジェクトを先行して作成してあるが、
	本来のマップが確定するのはこのタイミングなので、注意!
>>
*/
if(false){
//MAPPING_FILE=(no file)//値は未設定時の予約値?nullで初期化すべきか?
			if(! this.mapfile) this.mapfile='(no file)';

//マップファイルが未設定ならば、代用マップを使用
//この判定はあまりに雑なので後でなんとかすれ
if(false){
	if(this.mapfile=='(no file)')
	{
		MapObj=MAP;	//とりあえず既存のダミーマップを代入しておく。
	}
}
//マップファイルを読み込んでマップオブジェクトを初期化
	//	そのうちね、今はまだない
//日付関連

//制作日付と制作者が無い場合は、空白で初期化?無視したほうが良いかも
//CREATE_USER=''
//CREATE_TIME=''
			if(! this.create_time) this.create_time='';
			if(! this.create_user) this.create_user='';
//最終更新日付と最終更新者が無い場合は、空白で初期化?
//(これは、どのみち保存時に現在のデータで上書き)
//UPDATE_USER=''
//UPDATE_TIME=''
			if(! this.update_time) this.update_time='';
			if(! this.update_user) this.update_user='';
//
//FRAME_RATE=24//
//フレームレート読み取れてなければ、現在の値で初期化(組み込み注意)
			if(! this.framerate)
			{	this.framerate=nas.FRATE;
			}else{
				nas.FRATE=this.framerate;
			}
//トランシット展開しておく
//TRIN=(時間文字列),(トランシット種別)

if(! this.trin){
	this.trin=[0,"trin"]
}else{
	time=nas.FCT2Frm(this.trin[0]);
	if(isNaN(time)){time=0};
	name=(this.trin[1])?this.trin[1]:"trin";
	this.trin=[time,name];
}
//TROUT=(時間文字列),(トランシット種別)
if(! this.trout){
	this.trout=[0,"trout"];
}else{
	time=nas.FCT2Frm(this.trout[0]);
	if(isNaN(time)){time=0};
	name=(this.trout[1])?this.trout[1]:"trout";
	this.trout=[time,name];
}
//TIMEも一応取り込んでおく。
//実際のデータの継続時間とこの情報の「長いほう」を採る
//TIME=(時間文字列)
//			this.time=nas.FCT2Frm(this.time);
//			if(isNaN(this.time)){this.time=0}

//作品データ
//情報が無い場合は、空白で初期化。マップをみるようになったら。
//マップの情報を参照
//最終作業情報(クッキー)を参照
//ユーザ設定によるデフォルトを参照 などから選択


//TITLE=(未設定とかのほうが良いかも)
			if(! this.title) this.title='';
//SUB_TITLE=(未設定とかのほうが良いかも)
			if(! this.subtitle) this.subtitle='';
//OPUS=()
			if(! this.opus) this.opus='';
//SCENE=()
			if(! this.scene) this.scene='';
//CUT=()
			if(! this.cut) this.cut='';

//シーン?・カット番号は最終状態でもデフォルトは空白に。紛らわしいから。

}
if(this.errorCode){alert("error :"+this.errorCode+":"+this.errorMsg[this.errorCode]);this.errorCode=0};return true;
};

