/*	kacAE Ver0.3 試験版
倍率をキーフレーム指定して、擬似的に３次元（奥行き）であるかのように
スケーリングするエクスプレッション。本来のスケーリングとは別にエフェクトとして解決する。
とりあえず倍率指定/フレーム指定 兼用版
 このエクスプレッションのために以下のレイヤが必要である。

倍率／フレーム指定用レイヤとして
	effect("指定倍率(%)").param("スライダ")
位置指定レイヤとして
	effect("位置").param("ポイント")
フレームスキップ用コマ数指定レイヤとして
	effect("フレームスキップ").param("スライダ")
撮影フレーム指定スイッチとして
	effect("フレーム指定").param("チェックボックス")
フレーム指定時のフレーム数は伝統的なアニメーション撮影フレームの数値であるため
レタスフレームの指定はできません。
レタスフレームの指定は、リクエストが多ければ考えます。

○ レイヤを名前で参照するために、上記以外の名前をつかいたい場合は、
 エクスプレッションを修正する必要があります。
○この版は、３次元の値を処理するためにカラーレイヤを使用しています。
このエクスプレッションから値を取り出すには、値の各要素に30000を
乗算してもとの値を取り出してください。

 同梱のエフェクトテンプレートには組み込み済みです。


--- おことわり
このプログラムの著作権は「ねこまたや」にあります。

あなたは、このプログラムのこの著作権表示を改変しないかぎり
自由にプログラムの使用・複製・再配布などを行うことができます。

あなたは、このプログラムを自己の目的にしたがって改造することができます。
その場合、このプログラムを改造したものであることを明記して、この著作権表示を
添付するように努めてください。

このプログラムを使うも使わないもあなたの自由なのです。

作者はこのプログラムを使用したことによって起きたいかなる
不利益に対しても責任を負いません。
あなたは、あなたの判断と責任においてこのプログラムを使用するのです。

なんか、困ったことがあったら以下で連絡してもらえると何とかなるかもしれません。
http://homepage2.nifty.com/Nekomata/
mailto:nekomata_ya@mac.com

そんな感じです。

追伸　このプログラムは、まだ試験中なので
もう少し待つともっと良いものになるかもしれません。
再配布とかもう少し待ってみると良いかもしれませんね。

2004/04/19
計算結果の受け渡しをポイントレイヤに変更／出力値を二次元配列にする。2004/06/08
2004/08/29
位置指定可能な版を派生版として新規設置
ゼロトラップ追加
*/
function F2SwithSwitch(f){
if (effect("フレーム指定").param("チェックボックス")==true){
return 100*(160/(f+60))
}else{
return f
}}
//出力変数の初期化
var outputScale = 100;
outputPos = [0,0];
//vPos=[0,0];	
EXOUT=0;
prePos=[0,0];postPos=[0,0];
//参照すべきキーの総数を求める。
//失敗した時（キーまたはレイア自体がない場合）は、値を100%に初期化して終了
	var maxIndex = effect("指定倍率(%)").param("スライダ").num_keys
	if ( maxIndex != 0) {
// 再近接のキーの時間とインデックスを求める
	nKey = effect("指定倍率(%)").param("スライダ").nearest_key(time);
// 現在時と比較して前キーの値と後ろキーのインデックスを求める。
// 最少キーの前と最終キーの後ろは前後キーに同じ値を代入
	if( time >= nKey.time ) {
		var preIndex = nKey.index;
		var postIndex = nKey.index + 1;
		if(postIndex > maxIndex){postIndex = maxIndex}
	}else{
		var postIndex = nKey.index;
		var preIndex = nKey.index - 1;
		if(preIndex == 0){preIndex = 1}
	}
// 前後キーが一致している場合は、無条件で最近接キーの値を引き継いで終了
// 位置情報は、現時点のリニア位置情報
	if(preIndex == postIndex) {
		outputScale = F2SwithSwitch(nKey.value);
		outputPos = effect("位置").param("ポイント").value_at_time(time);
	} else {
//ステップ係数を取得 ステップ係数にしたがって算定用の時間オブジェクトを生成
//ステップ係数は、フレーム継続時間に掛ける値。スキップ0なら1、11なら12
var StepValue = Math.abs(effect("フレームスキップ").param("スライダ")) + 1;
//現在時間をステッピングする
if (StepValue == 1){var Stepedtime = time} else {
var Stepedtime= Math.floor(time /(this_comp.frame_duration * StepValue)) * (this_comp.frame_duration * StepValue);
}
//前と後ろのキーフレームオブジェクトを取得
	preKey = effect("指定倍率(%)").param("スライダ").key(preIndex);
	postKey = effect("指定倍率(%)").param("スライダ").key(postIndex);
// * 補正係数の分母を得るために前後キーの差をとっているので、
//前後キーの値が同一だとゼロ除算エラーになる
//回避のため前後キーの値が同一の場合最近接キーの値を与えて終了
// 位置情報は、現時点のリニア位置情報
if(preKey.value == postKey.value){
	outputScale = F2SwithSwitch(nKey.value);
	outputPos = effect("位置").param("ポイント").value_at_time(time);
} else {
if (effect("フレーム指定").param("チェックボックス")== false){
//被写体寸法からリニア
//前後のキーの値と現在のキーの値を比較して補正係数を取得
	var TimingValue = Math.abs(effect("指定倍率(%)").param("スライダ").value_at_time(Stepedtime) - preKey.value)/Math.abs(postKey.value - preKey.value);
//スライス数を取得=キー間の継続時間をフレーム継続時間で割る
	var SliceValue=(postKey.time - preKey.time)/this_comp.frame_duration;
/*
スライスポイントを取得 現在時間をフレーム継続時間で割って前キーの値を引く
//AEのキーオリジネーションが1なので前キーから1減算しておくこと
//	var SlicePoint= Stepedtime/this_comp.frame_duration - (preKey.index - 1) ;
スライスポイント算定方式変更のため不要
*/
//キータイミングを反映するために拡大比率をスライスポイントにすり替え
	SlicePoint = SliceValue * TimingValue;
//いつもの計算式で倍率を算出
//分子(preKey.value * postKey.value * SliceValue)/10000
//分母(preKey.value * SlicePoint + postKey.value * (SliceValue-SlicePoint))
outputScale = (preKey.value * postKey.value * SliceValue)/(preKey.value * SlicePoint + postKey.value * (SliceValue-SlicePoint))
} else {
//フレーム寸法から直接倍率割り出し
outputScale = F2SwithSwitch(effect("指定倍率(%)").param("スライダ").value_at_time(Stepedtime))
}
//スケールをもとに位置を算定
prePos	= effect("位置").param("ポイント").value_at_time(preKey.time)
postPos	= effect("位置").param("ポイント").value_at_time(postKey.time)
preScale	= preKey.value
postScale	= postKey.value
if (preScale==0 || postScale==0 || preScale==postScale){
	outputPos = effect("位置").param("ポイント").value_at_time(time);
		EXOUT=postScale;
} else {
	if(prePos==postPos){
		vPos = prePos ;
		EXOUT=999;
	}else{
		vPos = add(prePos,div(mul(sub(postPos,prePos),preScale),(preScale-postScale)));
EXOUT=vPos[0];
	}
outputPos = add(vPos,mul(div(sub(prePos,vPos),preScale),outputScale));
}
}}}
//
[(outputScale+30000)/60000,(outputPos[0]+30000)/60000,(outputPos[1]+30000)/60000,(EXOUT+30000)/60000]
/*
2004/04/17 バルク版ひとまず動作
フレームステップとタイミングカーブ参照はまだ。
04/17
ひとまず旧版の範囲まで消化
以降の拡張はタイミング参照およびステップ動作
ステップ動作はキーの値に関わらずフラット内か？継続時間を消化してO.L.か？

04/18
ホレ、タイミング情報の反映オワリわりと良いカンジ
検証グラフを書かせてみよう。見た。いけるみたい。

4/19
なんてことを言ってるうちにステップ動作も書いた
次は、フレーム数での指定かな
	とか思っていたらバグ発見
	前後キーの値が同じときゼロ除算？
	解決そろそろ公開？
無理矢理フレーム指定対応版　どうよ此れ？
いちお別セーブ
8/29
がぎがぎ　消失点対応版
消失点のキーフレーム指定と補完ができるぞ。
どうなのかしら？これは
*/
