/*
nas システムで利用するクラスターオブジェクト
Object UnitValue
	.type	String
	.value Number
Object Position
	.x	Object UnitValue
	.y	Object UnitValue
	.z	Object UnitValue
Object UnitAngle
	.value	Number
	.direction	String "clockwise","cw","anticlockwise" or "acw"
	.type	String unit "radians" or "degrees" 
Object Rotation 
	.x	Object UnitAngle
	.y	Object UnitAngle
	.z	Object UnitAngle
Object Offset
	.position	Object Position
	.rotation	Object Rotation
Object Resolution
	.type	String
	.value	Number
Object PixelAspect
	
Object Geometry
	汎用クラス　以下のプロパティを持つ
	.offset			アンカーポイント	Object Offset
	.position　		位置			Object Position
	.pixelPerInch		解像度			Object Resolution
	.pixelAspectRatio	ピクセル縦横比		Object Aspect
	.rotation		回転			Object Rotation

Object　Timing
	.
*/

/*
Object	UnitValue
実寸の値を持つオブジェクト　単位値
各単位間の相互変換機能を内包したオブジェクト
解釈する単位は
in,inches
mm,millimeters
cm,centimeters
pt,picas,points
コンストラクタ
nas.UnitValue
書式:	nas.UnitValue("unitValueString"[,"unitString"]);
	nas.UnitValue("単位付き数値文字列"[,"単位文字列"]);
単位省略時は"in"
戻り値はObject UnitValue
プロパティ:
	.type :String　内部単位系
	.value :Number float　数値、
メソッド:
	.as("unitValue")	:指定の単位に換算した数値を返す
	.convert("unitValue") :基準単位を変更して内部の数値を単位変換する
*/
function UnitValue(myValueString,myUnitString){
 if(isNaN(parseFloat(myValueString))){myValueString="0.0 pt"}else{myValueString+=""};
 if(!myUnitString){myUnitString="in"};
	this.type=(myValueString.match(/(in|inches|mm|millimeters|cm|centimeters|pt|picas|points)$/i))?RegExp.$1:myUnitString;
	this.value=new Number(parseFloat(myValueString));
	this.convert=function(myUnit){
		if(! myUnit){myUnit=""}
		if(myUnit.toString().match(/^(in|inches|mm|millimeters|cm|centimeters|pt|picas|points)$/i)){
			this.value=this.as(myUnit);
			this.type=myUnit;
			return true;
		}else{
			return false;
		};
	}
	this.as=function(myUnit){
		if(! myUnit){myUnit="in"};
		var myScale=1.;var targetScale=1.;
		switch (myUnit){
		case          "in":
		case      "inches": targetScale=72.;
		break;
		case          "mm":
		case "millimeters": targetScale=72./25.4;
		break;
		case          "cm":
		case "centimeters": targetScale=72./2.54;
		break;
		case          "pt":
		case       "picas":
		case      "points":
		default           : targetScale=1.;
		}
		switch (this.type){
		case          "in":
		case      "inches": myScale=72.;
		break;
		case          "mm":
		case "millimeters": myScale=72./25.40;
		break;
		case          "cm":
		case "centimeters": myScale=72./2.540;
		break;
		case          "pt":
		case       "picas":
		case      "points":
		default           : myScale=1.;
		}
		return (myScale*this.value) / (targetScale);
	}
	this.toString=function(){return this.value+" "+this.type;}
}
/* UnitValueTest
A=new UnitValue("yqwbd");//無意味な引数
A=new UnitValue(234,"pt");//分離型
A=new UnitValue("12 pt");
A.convert("cm");
A.convert("mm");
A.convert("in");
A.convert("pt");
A
*/
/*
Object UnitAngle
new UnitAngle(value or "value with unit"[,"unitString"])
Property:
	.value	Number
	.type	String unit "degrees"/"deg"/"d"or"radians"/"rad"/"r"
Method:
	.as("unitString") :

システムとして角度は一般角として定義する　右手系　反時計方向 が正方向である
単位系としての基本機能のみで回転方向はこのオブジェクトでは定義されない
*/
function UnitAngle(myValueString,myUnitString){
 if(isNaN(parseFloat(myValueString))){myValueString="0.0 radians"}else{myValueString+=""};
 if(!myUnitString){myUnitString="radians"};
 	this.type=(myValueString.match(/(radians|rad|r|degrees|deg|d)$/i))?RegExp.$1:myUnitString;
	this.value=new Number(parseFloat(myValueString));
	this.convert=function(myUnit){
		if(! myUnit){myUnit=""}
		if(myUnit.toString().match(/^(radians|rad|r|degrees|deg|d)$/i)){
			this.value=this.as(myUnit);
			this.type=myUnit;
			return true;
		}else{
			return false;
		};
	}
	this.as=function(myUnit){
		if(! myUnit){myUnit="radians"};
		var myScale=1.;var targetScale=1.;
		switch (myUnit){
		case      "degrees"	:
		case      "deg"	:
		case	   "d"		: targetScale=2*Math.PI;
		break;
		case       "radians"	:
		case       "rad"	:
		case       "r"		:
		default           	: targetScale=360.;
		}
		switch (this.type){
		case      "degrees"	:
		case      "deg"	:
		case	   "d"		: myScale=2*Math.PI;
		break;
		case       "radians"	:
		case       "rad"	:
		case       "r"		:
		default           	: myScale=360.;
		}
		return (myScale*this.value) / (targetScale);
	}
	this.toString=function(){return this.value+" "+this.type;}
}
/* UnitAngleTest
A=new UnitAngle("yqwbd");//無意味な引数
A=new UnitAngle(234,"deg");//分離型
A=new UnitAngle("1 rad");
A.convert("d");
A.convert("r");
A
*/

/*
Object Resolution 一考　環境値として保つ場合と個別に保持する場合であ扱いが変わるので注意？

	new Resolution (value[,aspect])
単一の数値とピクセル縦横比を持つ
単位付き数値文字列　または数値で指定
Aspectは縦に対する横の比率または配列で指定する　Resolution(72,0.5)は縦長ピクセル これはReslution(72,[1.,0.5,1.])に同じ
Aspect本体は3次元の配列
仮想の基準値を１とする各座標軸の比率となる
内部値は、ppcだがppi,ppc,ppmでの指定が可能
	.baseResolution	Number (dpc)
	.aspect	array[x,y,z]
	as()
*/
function Resolution(myValueString,myAspect){
 if(isNaN(parseFloat(myValueString))){myValueString="72 dpi"}else{myValueString+=""};
 if(!myUnitString){myUnitString="dpi"};
 	var myUnit=(myValueString.match(/((d|p|l)(pi|pc|pm))$/i))?RegExp.$1:"dpi";
	this.baseResolution=new Number(parseFloat(myValueString));
	this.convert=function(myUnit){
		if(! myUnit){myUnit=""}
		if(myUnit.toString().match(/^(radians|rad|r|degrees|deg|d)$/i)){
			this.value=this.as(myUnit);
			this.type=myUnit;
			return true;
		}else{
			return false;
		};
	}
	this.as=function(myUnit){
		if(! myUnit){myUnit="radians"};
		var myScale=1.;var targetScale=1.;
		switch (myUnit){
		case      "degrees"	:
		case      "deg"	:
		case	   "d"		: targetScale=2*Math.PI;
		break;
		case       "radians"	:
		case       "rad"	:
		case       "r"		:
		default           	: targetScale=360.;
		}
		switch (this.type){
		case      "degrees"	:
		case      "deg"	:
		case	   "d"		: myScale=2*Math.PI;
		break;
		case       "radians"	:
		case       "rad"	:
		case       "r"		:
		default           	: myScale=360.;
		}
		return (myScale*this.value) / (targetScale);
	}
	this.toString=function(){return this.value+" "+this.type;}	
}
